/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.AbstractHttpService;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.testing.junit4.server.ServerRule;
import io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.OpenTelemetryProtobufSpanUtils;
import org.mule.test.components.tracing.OpenTelemetryTracingTestCase;
import org.mule.test.components.tracing.OpenTelemetryTracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.infrastructure.profiling.tracing.TracingTestUtils;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class OpenTelemetryTracingRetryTestCase
extends OpenTelemetryTracingTestCase
implements OpenTelemetryTracingTestRunnerConfigAnnotation {
    private static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    private static final int MAX_BACKOFF_ATTEMPTS = 2;
    private static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    private static final String EXPECTED_SET_PAYLOAD_SPAN_NAME = "mule:set-payload";
    private static final String FLOW_LOCATION = "retry-flow";
    private static final String SET_PAYLOAD_LOCATION = "retry-flow/processors/0";
    private static final String TEST_ARTIFACT_ID = "OpenTelemetryTracingRetryTestCase#testRetryBackoffTest";
    private final String type;
    private final String path;
    @ClassRule
    public static final TestServerRule httpServer = new TestServerRule();

    protected String getConfigFile() {
        return "tracing/retry-backoff.xml";
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{{"HTTP", ""}});
    }

    public OpenTelemetryTracingRetryTestCase(String type, String path) {
        this.type = type;
        this.path = path;
    }

    protected void doSetUpBeforeMuleContextCreation() {
        System.setProperty("mule.openTelemetry.tracer.exporter.enabled", Boolean.TRUE.toString());
        System.setProperty("mule.openTelemetry.tracer.exporter.type", this.type);
        System.setProperty("mule.openTelemetry.tracer.exporter.endpoint", "http://localhost:" + httpServer.httpPort() + "/" + this.path);
        System.setProperty("mule.openTelemetry.tracer.exporter.backoff.maxAttempts", String.valueOf(2));
    }

    @After
    public void after() {
        System.clearProperty("mule.openTelemetry.tracer.exporter.enabled");
        System.clearProperty("mule.openTelemetry.tracer.exporter.type");
        System.clearProperty("mule.openTelemetry.tracer.exporter.endpoint");
        System.clearProperty("mule.openTelemetry.tracer.exporter.backoff.maxAttempts");
    }

    @Test
    public void testRetryBackoffTest() throws Exception {
        ((FlowRunner)this.flowRunner(FLOW_LOCATION).withPayload((Object)"test")).run().getMessage();
        PollingProber prober = new PollingProber(30000L, 100L);
        prober.check((Probe)new JUnitProbe(){

            protected boolean test() {
                List<CapturedExportedSpan> exportedSpans = httpServer.getCapturedExportedSpans();
                return exportedSpans.size() == 2;
            }

            public String describeFailure() {
                return "The exact amount of spans was not captured";
            }
        });
        List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
        List<CapturedExportedSpan> exportedSpans = httpServer.getCapturedExportedSpans();
        String artifactId = "OpenTelemetryTracingRetryTestCase#testRetryBackoffTest[" + this.type + "]";
        Map setPayloadAttributeMap = TracingTestUtils.createAttributeMap((String)SET_PAYLOAD_LOCATION, (String)artifactId);
        SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
        expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)FLOW_LOCATION, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_SET_PAYLOAD_SPAN_NAME).addAttributesToAssertValue(setPayloadAttributeMap).addAttributesToAssertExistence(attributesToAssertExistence).endChildren();
        expectedSpanHierarchy.assertSpanTree();
    }

    private static final class TestServerRule
    extends ServerRule {
        public static final String PATH_PATTERN = "/";
        private final List<CapturedExportedSpan> capturedExportedSpans = new ArrayList<CapturedExportedSpan>();
        private final AtomicInteger exportAttempts = new AtomicInteger(0);

        private TestServerRule() {
        }

        protected void configure(ServerBuilder sb) {
            sb.service(PATH_PATTERN, (HttpService)new AbstractHttpService(){

                @NotNull
                protected HttpResponse doPost(@NotNull ServiceRequestContext ctx, @NotNull HttpRequest req) {
                    return HttpResponse.from((CompletableFuture)req.aggregate().handle((aReq, cause) -> {
                        CompletableFuture<HttpResponse> responseFuture = new CompletableFuture<HttpResponse>();
                        HttpResponse res = HttpResponse.from(responseFuture);
                        if (exportAttempts.incrementAndGet() < 2) {
                            responseFuture.complete(HttpResponse.of((HttpStatus)HttpStatus.REQUEST_TIMEOUT));
                            return res;
                        }
                        try {
                            capturedExportedSpans.addAll(OpenTelemetryProtobufSpanUtils.getSpans(ExportTraceServiceRequest.parseFrom((InputStream)new ByteArrayInputStream(aReq.content().array()))));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        responseFuture.complete(HttpResponse.of((HttpStatus)HttpStatus.OK));
                        return res;
                    }));
                }
            });
            sb.http(0);
        }

        public List<CapturedExportedSpan> getCapturedExportedSpans() {
            return this.capturedExportedSpans;
        }
    }
}

