/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.mule.compatibility.core.api.endpoint.EndpointBuilder;
import org.mule.compatibility.core.api.endpoint.EndpointFactory;
import org.mule.compatibility.core.api.endpoint.ImmutableEndpoint;
import org.mule.compatibility.core.api.endpoint.InboundEndpoint;
import org.mule.compatibility.core.api.endpoint.OutboundEndpoint;
import org.mule.compatibility.core.api.transport.Connector;
import org.mule.compatibility.core.endpoint.EndpointURIEndpointBuilder;
import org.mule.compatibility.core.transport.AbstractConnector;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.MessageExchangePattern;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.registry.MuleRegistry;
import org.mule.runtime.core.api.routing.filter.Filter;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionFactory;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.routing.MessageFilter;
import org.mule.runtime.core.transaction.MuleTransactionConfig;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.testmodels.mule.TestTransactionFactory;

public final class MuleEndpointTestUtils {
    public static InboundEndpoint getTestInboundEndpoint(String name, MuleContext context) throws Exception {
        return (InboundEndpoint)MuleEndpointTestUtils.getTestEndpoint(name, null, null, null, null, context, builder -> MuleEndpointTestUtils.getEndpointFactory(context.getRegistry()).getInboundEndpoint(builder), null);
    }

    public static OutboundEndpoint getTestOutboundEndpoint(String name, MuleContext context) throws Exception {
        return (OutboundEndpoint)MuleEndpointTestUtils.getTestEndpoint(name, null, null, null, null, context, builder -> MuleEndpointTestUtils.getEndpointFactory(context.getRegistry()).getOutboundEndpoint(builder), null);
    }

    public static InboundEndpoint getTestInboundEndpoint(String name, MuleContext context, String uri, List<Transformer> transformers, Filter filter, Map<String, Serializable> properties, Connector connector) throws Exception {
        return (InboundEndpoint)MuleEndpointTestUtils.getTestEndpoint(name, uri, transformers, filter, properties, context, builder -> MuleEndpointTestUtils.getEndpointFactory(context.getRegistry()).getInboundEndpoint(builder), connector);
    }

    public static OutboundEndpoint getTestOutboundEndpoint(String name, MuleContext context, String uri, List<Transformer> transformers, Filter filter, Map<String, Serializable> properties) throws Exception {
        return (OutboundEndpoint)MuleEndpointTestUtils.getTestEndpoint(name, uri, transformers, filter, properties, context, builder -> MuleEndpointTestUtils.getEndpointFactory(context.getRegistry()).getOutboundEndpoint(builder), null);
    }

    public static InboundEndpoint getTestInboundEndpoint(String name, MuleContext context, String uri, List<Transformer> transformers, Filter filter, Map<String, Serializable> properties) throws Exception {
        return (InboundEndpoint)MuleEndpointTestUtils.getTestEndpoint(name, uri, transformers, filter, properties, context, builder -> MuleEndpointTestUtils.getEndpointFactory(context.getRegistry()).getInboundEndpoint(builder), null);
    }

    public static OutboundEndpoint getTestOutboundEndpoint(String name, MuleContext context, String uri, List<Transformer> transformers, Filter filter, Map<String, Serializable> properties, Connector connector) throws Exception {
        return (OutboundEndpoint)MuleEndpointTestUtils.getTestEndpoint(name, uri, transformers, filter, properties, context, builder -> {
            builder.setConnector(connector);
            return MuleEndpointTestUtils.getEndpointFactory(context.getRegistry()).getOutboundEndpoint(builder);
        }, null);
    }

    public static OutboundEndpoint getTestOutboundEndpoint(MessageExchangePattern mep, MuleContext context, String uri, Connector connector) throws Exception {
        return (OutboundEndpoint)MuleEndpointTestUtils.getTestEndpoint(null, uri, null, null, null, context, builder -> {
            builder.setConnector(connector);
            builder.setExchangePattern(mep);
            return MuleEndpointTestUtils.getEndpointFactory(context.getRegistry()).getOutboundEndpoint(builder);
        }, null);
    }

    public static OutboundEndpoint getTestOutboundEndpoint(String name, MessageExchangePattern mep, MuleContext context) throws Exception {
        return (OutboundEndpoint)MuleEndpointTestUtils.getTestEndpoint(name, null, null, null, null, context, builder -> {
            builder.setExchangePattern(mep);
            return MuleEndpointTestUtils.getEndpointFactory(context.getRegistry()).getOutboundEndpoint(builder);
        }, null);
    }

    public static OutboundEndpoint getTestOutboundEndpoint(MessageExchangePattern mep, MuleContext context) throws Exception {
        return (OutboundEndpoint)MuleEndpointTestUtils.getTestEndpoint(null, null, null, null, null, context, builder -> {
            builder.setExchangePattern(mep);
            return MuleEndpointTestUtils.getEndpointFactory(context.getRegistry()).getOutboundEndpoint(builder);
        }, null);
    }

    public static InboundEndpoint getTestInboundEndpoint(String name, MessageExchangePattern mep, MuleContext context, Connector connector) throws Exception {
        return (InboundEndpoint)MuleEndpointTestUtils.getTestEndpoint(name, null, null, null, null, context, builder -> {
            builder.setExchangePattern(mep);
            return MuleEndpointTestUtils.getEndpointFactory(context.getRegistry()).getInboundEndpoint(builder);
        }, connector);
    }

    public static InboundEndpoint getTestInboundEndpoint(MessageExchangePattern mep, MuleContext context) throws Exception {
        return (InboundEndpoint)MuleEndpointTestUtils.getTestEndpoint(null, null, null, null, null, context, builder -> {
            builder.setExchangePattern(mep);
            return MuleEndpointTestUtils.getEndpointFactory(context.getRegistry()).getInboundEndpoint(builder);
        }, null);
    }

    public static InboundEndpoint getTestTransactedInboundEndpoint(MessageExchangePattern mep, MuleContext context) throws Exception {
        return (InboundEndpoint)MuleEndpointTestUtils.getTestEndpoint(null, null, null, null, null, context, builder -> {
            builder.setExchangePattern(mep);
            MuleTransactionConfig txConfig = new MuleTransactionConfig(2);
            txConfig.setFactory((TransactionFactory)new TestTransactionFactory());
            builder.setTransactionConfig((TransactionConfig)txConfig);
            return MuleEndpointTestUtils.getEndpointFactory(context.getRegistry()).getInboundEndpoint(builder);
        }, null);
    }

    private static ImmutableEndpoint getTestEndpoint(String name, String uri, List<Transformer> transformers, Filter filter, Map<String, Serializable> properties, MuleContext context, EndpointSource source, Connector connector) throws Exception {
        String endpoingUri = uri == null ? "test://test" : uri;
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder(endpoingUri, context);
        endpointBuilder.setConnector(connector);
        endpointBuilder.setName(name);
        if (transformers != null) {
            endpointBuilder.setTransformers(transformers);
        }
        if (properties != null) {
            endpointBuilder.setProperties(properties);
        }
        endpointBuilder.addMessageProcessor((Processor)new MessageFilter(filter));
        return source.getEndpoint((EndpointBuilder)endpointBuilder);
    }

    public static ImmutableEndpoint getTestSchemeMetaInfoInboundEndpoint(String name, String protocol, MuleContext context) throws Exception {
        return MuleEndpointTestUtils.getTestSchemeMetaInfoEndpoint(name, protocol, context, builder -> MuleEndpointTestUtils.getEndpointFactory(context.getRegistry()).getInboundEndpoint(builder));
    }

    public static ImmutableEndpoint getTestSchemeMetaInfoOutboundEndpoint(String name, String protocol, MuleContext context) throws Exception {
        return MuleEndpointTestUtils.getTestSchemeMetaInfoEndpoint(name, protocol, context, builder -> MuleEndpointTestUtils.getEndpointFactory(context.getRegistry()).getOutboundEndpoint(builder));
    }

    private static ImmutableEndpoint getTestSchemeMetaInfoEndpoint(String name, String protocol, MuleContext context, EndpointSource source) throws Exception {
        AbstractConnector connector = (AbstractConnector)ClassUtils.loadClass((String)"org.mule.tck.testmodels.mule.TestConnector", AbstractMuleTestCase.class).newInstance();
        connector.setName("testConnector");
        context.getRegistry().applyLifecycle((Object)connector);
        connector.registerSupportedProtocol(protocol);
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder("test:" + protocol + "://test", context);
        endpointBuilder.setConnector((Connector)connector);
        endpointBuilder.setName(name);
        return source.getEndpoint((EndpointBuilder)endpointBuilder);
    }

    public static EndpointFactory getEndpointFactory(MuleRegistry registry) {
        return (EndpointFactory)registry.lookupObject("_muleEndpointFactory");
    }

    public static EndpointBuilder lookupEndpointBuilder(MuleRegistry registry, String name) {
        Object o = registry.lookupObject(name);
        if (o instanceof EndpointBuilder) {
            return (EndpointBuilder)o;
        }
        return null;
    }

    private static interface EndpointSource {
        public ImmutableEndpoint getEndpoint(EndpointBuilder var1) throws MuleException;
    }
}

