/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.transformer.simple;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.MuleSession;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.processor.simple.AbstractRemoveVariablePropertyProcessor;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public abstract class AbstractRemoveVariablePropertyProcessorTestCase
extends AbstractMuleContextTestCase {
    public static final Charset ENCODING = StandardCharsets.US_ASCII;
    public static final String PLAIN_STRING_KEY = "someText";
    public static final String PLAIN_STRING_VALUE = "someValue";
    public static final String EXPRESSION = "#[mel:string:someValue]";
    public static final String EXPRESSION_VALUE = "expressionValueResult";
    public static final String NULL_EXPRESSION = "#[mel:string:someValueNull]";
    public static final String NULL_EXPRESSION_VALUE = null;
    private InternalMessage message;
    private Event event;
    private MuleSession mockSession = (MuleSession)Mockito.mock(MuleSession.class);
    private MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class);
    private ExtendedExpressionManager mockExpressionManager = (ExtendedExpressionManager)Mockito.mock(ExtendedExpressionManager.class);
    private TypedValue<String> typedValue;
    private AbstractRemoveVariablePropertyProcessor removeVariableProcessor;

    public AbstractRemoveVariablePropertyProcessorTestCase(AbstractRemoveVariablePropertyProcessor abstractAddVariableProcessor) {
        this.removeVariableProcessor = abstractAddVariableProcessor;
    }

    @Before
    public void setUpTest() throws Exception {
        this.message = InternalMessage.builder().payload((Object)"").build();
        this.event = AbstractRemoveVariablePropertyProcessorTestCase.eventBuilder().message((Message)this.message).session(this.mockSession).build();
        Mockito.when((Object)this.mockMuleContext.getConfiguration()).thenReturn(Mockito.mock(MuleConfiguration.class));
        Mockito.when((Object)this.mockMuleContext.getExpressionManager()).thenReturn((Object)this.mockExpressionManager);
        this.typedValue = new TypedValue((Object)EXPRESSION_VALUE, DataType.STRING);
        Mockito.when((Object)this.mockExpressionManager.parse(Matchers.anyString(), (Event)Matchers.any(Event.class), (FlowConstruct)Matchers.any(FlowConstruct.class))).thenAnswer(invocation -> invocation.getArguments()[0]);
        Mockito.when((Object)this.mockExpressionManager.evaluate(EXPRESSION, this.event)).thenReturn(this.typedValue);
        this.removeVariableProcessor.setMuleContext(this.mockMuleContext);
    }

    @Test
    public void testRemoveVariable() throws MuleException {
        this.removeVariableProcessor.setIdentifier(PLAIN_STRING_KEY);
        this.removeVariableProcessor.initialise();
        this.event = this.removeVariableProcessor.process(this.event);
        this.verifyRemoved(this.event, PLAIN_STRING_KEY);
    }

    @Test
    public void testRemoveVariableUsingExpression() throws MuleException {
        this.removeVariableProcessor.setIdentifier(EXPRESSION);
        this.removeVariableProcessor.initialise();
        this.event = this.removeVariableProcessor.process(this.event);
        this.verifyRemoved(this.event, EXPRESSION_VALUE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRemoveVariableNullKey() throws InitialisationException, TransformerException {
        this.removeVariableProcessor.setIdentifier(null);
    }

    @Test
    public void testRemoveVariableExpressionKeyNullValue() throws MuleException {
        TypedValue typedValue = new TypedValue(null, DataType.OBJECT);
        Mockito.when((Object)this.mockExpressionManager.evaluate(NULL_EXPRESSION, this.event)).thenReturn((Object)typedValue);
        this.removeVariableProcessor.setIdentifier(NULL_EXPRESSION);
        this.removeVariableProcessor.initialise();
        this.event = this.removeVariableProcessor.process(this.event);
    }

    @Test
    @Ignore
    public void testRemoveVariableWithRegexExpression() throws MuleException {
        this.addMockedPropeerties(this.event, new HashSet<String>(Arrays.asList("MULE_ID", "MULE_CORRELATION_ID", "SomeVar", "MULE_GROUP_ID")));
        this.removeVariableProcessor.setIdentifier("MULE_(.*)");
        this.removeVariableProcessor.initialise();
        this.event = this.removeVariableProcessor.process(this.event);
        this.verifyRemoved(this.event, "MULE_ID");
        this.verifyRemoved(this.event, "MULE_CORRELATION_ID");
        this.verifyRemoved(this.event, "MULE_GROUP_ID");
        this.verifyNotRemoved(this.event, "SomeVar");
    }

    protected abstract void addMockedPropeerties(Event var1, HashSet var2);

    protected abstract void verifyRemoved(Event var1, String var2);

    protected abstract void verifyNotRemoved(Event var1, String var2);
}

