/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.config;

import com.mulesoft.weave.el.WeaveExpressionExecutor;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.Assert;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.registry.MuleRegistry;
import org.mule.runtime.core.config.builders.AbstractConfigurationBuilder;
import org.mule.service.http.api.HttpService;
import org.mule.tck.SimpleUnitTestSupportSchedulerService;

public class TestServicesConfigurationBuilder
extends AbstractConfigurationBuilder {
    private static final String MOCK_HTTP_SERVICE = "mockHttpService";
    final SimpleUnitTestSupportSchedulerService schedulerService = new SimpleUnitTestSupportSchedulerService();
    final WeaveExpressionExecutor weaveExpressionExecutor = new WeaveExpressionExecutor();
    private boolean mockHttpService;

    public TestServicesConfigurationBuilder() {
        this(true);
    }

    public TestServicesConfigurationBuilder(boolean mockHttpService) {
        this.mockHttpService = mockHttpService;
    }

    public void doConfigure(MuleContext muleContext) throws Exception {
        MuleRegistry registry = muleContext.getRegistry();
        registry.registerObject(this.schedulerService.getName(), Mockito.spy((Object)this.schedulerService));
        registry.registerObject(this.weaveExpressionExecutor.getName(), (Object)this.weaveExpressionExecutor);
        if (this.mockHttpService) {
            registry.registerObject(MOCK_HTTP_SERVICE, Mockito.mock(HttpService.class));
        }
    }

    public void stopServices() throws MuleException {
        List<Scheduler> schedulers = this.schedulerService.getSchedulers();
        try {
            Assert.assertThat(schedulers, (Matcher)IsEmptyCollection.empty());
        }
        finally {
            this.schedulerService.stop();
        }
    }
}

