/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4.matcher;

import java.nio.charset.Charset;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;

public class DataTypeMatcher
extends TypeSafeMatcher<DataType> {
    private final Class type;
    private final MediaType mimeType;
    private final Charset encoding;

    public DataTypeMatcher(Class type, MediaType mimeType, Charset encoding) {
        this.type = type;
        this.mimeType = mimeType;
        this.encoding = encoding;
    }

    protected boolean matchesSafely(DataType dataType) {
        boolean sameEncoding;
        boolean sameType;
        boolean bl = this.type == null ? dataType.getType() == null : (sameType = this.type.equals(dataType.getType()));
        boolean bl2 = this.encoding == null ? !dataType.getMediaType().getCharset().isPresent() : (sameEncoding = this.encoding.equals(dataType.getMediaType().getCharset().get()));
        boolean sameMimeType = this.mimeType == null ? dataType.getMediaType() == null : this.mimeType.matches(dataType.getMediaType());
        return sameType && sameEncoding && sameMimeType;
    }

    public void describeTo(Description description) {
        description.appendText("a dataType with type = ").appendValue((Object)this.type.getName()).appendText(", mimeType = ").appendValue((Object)this.mimeType).appendText(", encoding = ").appendValue((Object)this.encoding);
    }

    protected void describeMismatchSafely(DataType dataType, Description mismatchDescription) {
        mismatchDescription.appendText("got a dataType with type = ").appendValue((Object)dataType.getType().getName()).appendText(", mimeType = ").appendValue((Object)dataType.getMediaType()).appendText(", encoding = ").appendValue((Object)dataType.getMediaType().getCharset());
    }

    @Factory
    public static Matcher<DataType> like(Class type, MediaType mimeType, Charset encoding) {
        return new DataTypeMatcher(type, mimeType, encoding);
    }

    @Factory
    public static Matcher<DataType> like(DataType dataType) {
        return new DataTypeMatcher(dataType.getType(), dataType.getMediaType(), dataType.getMediaType().getCharset().orElse(null));
    }
}

