/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.core.util.StringUtils;
import org.mule.tck.ZipUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompilerUtils {
    private static final Logger logger = LoggerFactory.getLogger(CompilerUtils.class);
    private static final String EXTENSION_ANNOTATION_PROCESSOR_CLASSNAME = "org.mule.runtime.module.extension.internal.resources.ExtensionResourcesGeneratorAnnotationProcessor";

    private static class CompilerTask {
        private final File[] sources;
        private final List<String> options;

        private CompilerTask(File[] sources, List<String> options) {
            this.sources = sources;
            this.options = options;
        }

        public void compile() {
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
            try {
                Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjects(this.sources);
                JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, null, this.options, null, compilationUnits);
                Boolean status = task.call();
                if (!status.booleanValue()) {
                    throw new RuntimeException("Compiler task finished with error. Enable logging to find more information");
                }
            }
            catch (Throwable e) {
                logger.error("Error processing compilation task", e);
                throw e;
            }
            finally {
                try {
                    fileManager.close();
                }
                catch (IOException compilationUnits) {}
            }
        }
    }

    private static class CompilerTaskBuilder {
        private File target;
        private File[] sources = new File[0];
        private File[] jarFiles = new File[0];
        private String annotationProcessorClassName;
        private final List<String> processProperties = new ArrayList<String>();

        private CompilerTaskBuilder() {
        }

        public CompilerTaskBuilder toTarget(File target) {
            this.target = target;
            return this;
        }

        public CompilerTaskBuilder dependingOn(File ... jarFiles) {
            this.jarFiles = jarFiles;
            return this;
        }

        public CompilerTaskBuilder compiling(File ... sources) {
            this.sources = sources;
            return this;
        }

        public CompilerTaskBuilder withProperty(String name, String value) {
            this.processProperties.add("-A" + name + "=" + value);
            return this;
        }

        public CompilerTaskBuilder processingAnnotations(String annotationProcessorClassName) {
            this.annotationProcessorClassName = annotationProcessorClassName;
            return this;
        }

        public CompilerTask build() {
            if (this.sources.length == 0) {
                throw new IllegalArgumentException("Must define at least a source file to compile");
            }
            return new CompilerTask(this.sources, this.getOptions());
        }

        private List<String> getOptions() {
            ArrayList<String> options = new ArrayList<String>();
            if (logger.isInfoEnabled()) {
                options.add("-verbose");
            }
            if (this.annotationProcessorClassName == null) {
                options.add("-proc:none");
            } else {
                options.add("-processor");
                options.add(this.annotationProcessorClassName);
                options.add("-proc:only");
            }
            if (this.target != null) {
                options.add("-d");
                options.add(this.target.getAbsolutePath());
            }
            if (this.jarFiles.length > 0) {
                String classPath = System.getProperty("java.class.path");
                for (File jarFile : this.jarFiles) {
                    classPath = classPath + File.pathSeparator + jarFile.getAbsolutePath();
                }
                options.addAll(Arrays.asList("-classpath", classPath));
            }
            options.addAll(this.processProperties);
            return options;
        }
    }

    public static class ExtensionCompiler
    extends MultipleFileCompiler<ExtensionCompiler> {
        @Override
        protected ExtensionCompiler getThis() {
            return this;
        }

        public File compile(String jarName, String extensionVersion) {
            Preconditions.checkArgument((!StringUtils.isEmpty((String)jarName) ? 1 : 0) != 0, (String)"jarName cannot be empty");
            Preconditions.checkArgument((!StringUtils.isEmpty((String)extensionVersion) ? 1 : 0) != 0, (String)"extensionVersion cannot be empty");
            File targetFolder = this.createTargetFolder();
            this.compileJavaSources(targetFolder);
            this.processExtensionAnnotations(targetFolder, extensionVersion);
            return this.compressGeneratedFiles(targetFolder, jarName);
        }

        private void processExtensionAnnotations(File targetFolder, String extensionVersion) {
            URLClassLoader urlClassLoader = this.createExtensionClassLoader(targetFolder);
            ClassUtils.withContextClassLoader((ClassLoader)urlClassLoader, () -> {
                File metaInfFolder = new File(targetFolder, "META-INF");
                metaInfFolder.mkdir();
                CompilerTask compilerTask = new CompilerTaskBuilder().compiling(this.sources).dependingOn(this.requiredJars).withProperty("extension.version", extensionVersion).processingAnnotations(CompilerUtils.EXTENSION_ANNOTATION_PROCESSOR_CLASSNAME).toTarget(metaInfFolder).build();
                compilerTask.compile();
            });
        }

        private URLClassLoader createExtensionClassLoader(File targetFolder) {
            URLClassLoader urlClassLoader;
            try {
                urlClassLoader = new URLClassLoader(new URL[]{targetFolder.toURL()});
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            return urlClassLoader;
        }
    }

    public static class JarCompiler
    extends MultipleFileCompiler<JarCompiler> {
        public File compile(String jarName) {
            File targetFolder = this.createTargetFolder();
            this.compileJavaSources(targetFolder);
            return this.compressGeneratedFiles(targetFolder, jarName);
        }

        @Override
        protected JarCompiler getThis() {
            return this;
        }
    }

    protected static abstract class MultipleFileCompiler<T extends MultipleFileCompiler>
    extends AbstractCompiler<T> {
        private List<ZipUtils.ZipResource> configuredResources = new ArrayList<ZipUtils.ZipResource>();

        protected MultipleFileCompiler() {
        }

        public T compiling(File ... sources) {
            Preconditions.checkArgument((sources != null && sources.length > 0 ? 1 : 0) != 0, (String)"source cannot be empty");
            this.sources = sources;
            return (T)((MultipleFileCompiler)this.getThis());
        }

        public T including(File resource, String alias) {
            this.configuredResources.add(new ZipUtils.ZipResource(resource.getAbsolutePath(), alias));
            return (T)((MultipleFileCompiler)this.getThis());
        }

        protected File compressGeneratedFiles(File targetFolder, String jarName) {
            Preconditions.checkArgument((targetFolder != null ? 1 : 0) != 0, (String)"targetFolder cannot be byll");
            Preconditions.checkArgument((!StringUtils.isEmpty((String)jarName) ? 1 : 0) != 0, (String)"jar name cannot be empty");
            Collection files = FileUtils.listFiles((File)targetFolder, (IOFileFilter)TrueFileFilter.TRUE, (IOFileFilter)TrueFileFilter.TRUE);
            ZipUtils.ZipResource[] resources = this.getZipResources(targetFolder, files);
            File targetFile = new File(targetFolder, jarName);
            ZipUtils.compress(targetFile, resources);
            return targetFile;
        }

        private ZipUtils.ZipResource[] getZipResources(File targetFolder, Collection<File> classes) {
            List<ZipUtils.ZipResource> compiledResources = classes.stream().map(f -> new ZipUtils.ZipResource(f.getAbsolutePath(), this.getRelativePath(targetFolder, (File)f))).collect(Collectors.toList());
            compiledResources.addAll(this.configuredResources);
            return compiledResources.toArray(new ZipUtils.ZipResource[0]);
        }

        private String getRelativePath(File targetFolder, File file) {
            return file.getAbsolutePath().substring(targetFolder.getAbsolutePath().length() + 1);
        }
    }

    public static class SingleClassCompiler
    extends AbstractCompiler<SingleClassCompiler> {
        private File targetFolder;

        public File compile(File source) {
            Preconditions.checkArgument((source != null ? 1 : 0) != 0, (String)"source cannot be null");
            this.targetFolder = this.createTargetFolder();
            this.sources = new File[]{source};
            this.compileJavaSources(this.targetFolder);
            return this.getCompiledClass(this.targetFolder, source.getName());
        }

        public File getTargetFolder() {
            return this.targetFolder;
        }

        private File getCompiledClass(File targetFolder, String name) {
            String className = name.replace("java", "class");
            Collection classes = FileUtils.listFiles((File)targetFolder, (IOFileFilter)new NameFileFilter(className), (IOFileFilter)TrueFileFilter.TRUE);
            if (classes.size() > 1) {
                throw new IllegalStateException("Cannot return compiled class as there are more than one compiled class file");
            }
            return (File)classes.iterator().next();
        }

        @Override
        protected SingleClassCompiler getThis() {
            return this;
        }
    }

    private static abstract class AbstractCompiler<T extends AbstractCompiler> {
        protected File[] requiredJars = new File[0];
        protected File[] sources = new File[0];

        private AbstractCompiler() {
        }

        protected abstract T getThis();

        public T dependingOn(File ... requiredJars) {
            this.requiredJars = requiredJars;
            return this.getThis();
        }

        protected File createTargetFolder() {
            try {
                File tempFolder = File.createTempFile(CompilerUtils.class.getSimpleName(), "");
                tempFolder.delete();
                tempFolder.mkdir();
                return tempFolder;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        protected void compileJavaSources(File targetFolder) {
            Preconditions.checkArgument((targetFolder != null ? 1 : 0) != 0, (String)"targetFolder cannot be null");
            CompilerTask compilerTask = new CompilerTaskBuilder().compiling(this.sources).dependingOn(this.requiredJars).toTarget(targetFolder).build();
            compilerTask.compile();
        }
    }
}

