/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.core.util.queue;

import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.api.util.concurrent.Latch;
import org.mule.runtime.core.api.util.queue.DefaultQueueConfiguration;
import org.mule.runtime.core.api.util.queue.Queue;
import org.mule.runtime.core.api.util.queue.QueueConfiguration;
import org.mule.runtime.core.api.util.queue.QueueManager;
import org.mule.runtime.core.api.util.queue.QueueSession;
import org.mule.runtime.core.internal.util.queue.AbstractQueueManager;
import org.mule.tck.core.util.queue.QueueTestComponent;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransactionQueueManagerTestCase
extends AbstractMuleContextTestCase {
    public static final int THREAD_EXECUTION_TIMEOUT = 2000;
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected QueueTestComponent disposeTest = new QueueTestComponent();

    protected abstract AbstractQueueManager createQueueManager() throws Exception;

    protected abstract boolean isPersistent();

    @Test
    public void testPutTake() throws Exception {
        AbstractQueueManager mgr = this.createQueueManager();
        mgr.start();
        QueueSession s = mgr.getQueueSession();
        Queue q = s.getQueue("queue1");
        Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
        q.put((Serializable)((Object)"String1"));
        Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
        Serializable o = q.take();
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((String)"Queue content", (Object)"String1", (Object)o);
        Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
        mgr.stop();
    }

    @Test
    public void testTakePut() throws Exception {
        AbstractQueueManager mgr = this.createQueueManager();
        mgr.start();
        final Latch latch = new Latch();
        Thread t = new Thread((QueueManager)mgr){
            final /* synthetic */ QueueManager val$mgr;
            {
                this.val$mgr = queueManager;
            }

            @Override
            public void run() {
                try {
                    latch.countDown();
                    Thread.sleep(200L);
                    QueueSession s = this.val$mgr.getQueueSession();
                    Queue q = s.getQueue("queue1");
                    Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
                    q.put((Serializable)((Object)"String1"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        t.start();
        latch.await();
        long t0 = System.currentTimeMillis();
        QueueSession s = mgr.getQueueSession();
        Queue q = s.getQueue("queue1");
        Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
        Serializable o = q.take();
        long t1 = System.currentTimeMillis();
        t.join();
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((String)"Queue content", (Object)"String1", (Object)o);
        Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
        Assert.assertTrue((t1 - t0 > 100L ? 1 : 0) != 0);
        mgr.stop();
    }

    @Test
    public void testPutTakeUntake() throws Exception {
        AbstractQueueManager mgr = this.createQueueManager();
        mgr.start();
        final Latch latch = new Latch();
        Thread t = new Thread((QueueManager)mgr){
            final /* synthetic */ QueueManager val$mgr;
            {
                this.val$mgr = queueManager;
            }

            @Override
            public void run() {
                try {
                    latch.countDown();
                    Thread.sleep(200L);
                    QueueSession s = this.val$mgr.getQueueSession();
                    Queue q = s.getQueue("queue1");
                    Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
                    q.put((Serializable)((Object)"String1"));
                    q.put((Serializable)((Object)"String2"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        t.start();
        latch.await();
        long t0 = System.currentTimeMillis();
        QueueSession s = mgr.getQueueSession();
        Queue q = s.getQueue("queue1");
        Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
        Serializable o = q.take();
        long t1 = System.currentTimeMillis();
        t.join();
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((String)"Queue content", (Object)"String1", (Object)o);
        Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
        Assert.assertTrue((t1 - t0 > 100L ? 1 : 0) != 0);
        q.untake(o);
        Assert.assertEquals((String)"Queue size", (long)2L, (long)q.size());
        Serializable o2 = q.take();
        Assert.assertEquals((String)"Queue content", (Object)"String1", (Object)o2);
        Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
        mgr.stop();
    }

    @Test
    public void testClearWithoutTransaction() throws Exception {
        AbstractQueueManager mgr = this.createQueueManager();
        mgr.start();
        QueueSession s = mgr.getQueueSession();
        Queue q = s.getQueue("queue1");
        Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
        q.put((Serializable)((Object)"String1"));
        Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
        q.clear();
        Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
        mgr.stop();
    }

    @Test
    public void testClearInTransaction() throws Exception {
        AbstractQueueManager mgr = this.createQueueManager();
        mgr.start();
        QueueSession s = mgr.getQueueSession();
        s.begin();
        Queue q = s.getQueue("queue1");
        Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
        q.put((Serializable)((Object)"String1"));
        s.commit();
        Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
        s.begin();
        Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
        q.clear();
        s.rollback();
        Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
        s.begin();
        Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
        q.clear();
        s.commit();
        Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
        mgr.stop();
    }

    @Test
    public void testTakePutRollbackPut() throws Exception {
        AbstractQueueManager mgr = this.createQueueManager();
        mgr.start();
        final Latch latch = new Latch();
        Thread t = new Thread((QueueManager)mgr){
            final /* synthetic */ QueueManager val$mgr;
            {
                this.val$mgr = queueManager;
            }

            @Override
            public void run() {
                try {
                    latch.countDown();
                    Thread.sleep(200L);
                    QueueSession s = this.val$mgr.getQueueSession();
                    Queue q = s.getQueue("queue1");
                    Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
                    s.begin();
                    q.put((Serializable)((Object)"String1"));
                    s.rollback();
                    s.begin();
                    q.put((Serializable)((Object)"String2"));
                    s.commit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        t.start();
        latch.await();
        long t0 = System.currentTimeMillis();
        QueueSession s = mgr.getQueueSession();
        Queue q = s.getQueue("queue1");
        Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
        Serializable o = q.take();
        long t1 = System.currentTimeMillis();
        t.join();
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((String)"Queue content", (Object)"String2", (Object)o);
        Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
        Assert.assertTrue((t1 - t0 > 100L ? 1 : 0) != 0);
        mgr.stop();
    }

    @Test
    public void testPutTakeUntakeRollbackUntake() throws Exception {
        AbstractQueueManager mgr = this.createQueueManager();
        mgr.start();
        final Latch latch = new Latch();
        String object1 = "string1";
        String object2 = "string2";
        Thread t = new Thread((QueueManager)mgr, (Serializable)((Object)object1), (Serializable)((Object)object2)){
            final /* synthetic */ QueueManager val$mgr;
            final /* synthetic */ Serializable val$object1;
            final /* synthetic */ Serializable val$object2;
            {
                this.val$mgr = queueManager;
                this.val$object1 = serializable;
                this.val$object2 = serializable2;
            }

            @Override
            public void run() {
                try {
                    latch.countDown();
                    Thread.sleep(200L);
                    QueueSession s = this.val$mgr.getQueueSession();
                    Queue q = s.getQueue("queue1");
                    Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
                    s.begin();
                    q.untake(this.val$object1);
                    s.commit();
                    s.begin();
                    q.untake(this.val$object2);
                    s.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        t.start();
        latch.await();
        long t0 = System.currentTimeMillis();
        QueueSession s = mgr.getQueueSession();
        Queue q = s.getQueue("queue1");
        Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
        Serializable o = q.take();
        long t1 = System.currentTimeMillis();
        t.join();
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((String)"Queue content", (Object)object1, (Object)o);
        Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
        Assert.assertTrue((t1 - t0 > 100L ? 1 : 0) != 0);
        mgr.stop();
    }

    @Test
    public void testTakePutOverCapacity() throws Exception {
        AbstractQueueManager mgr = this.createQueueManager();
        mgr.start();
        mgr.setDefaultQueueConfiguration((QueueConfiguration)new DefaultQueueConfiguration(2, false));
        final Latch latch = new Latch();
        Thread t = new Thread((QueueManager)mgr){
            final /* synthetic */ QueueManager val$mgr;
            {
                this.val$mgr = queueManager;
            }

            @Override
            public void run() {
                try {
                    latch.await();
                    Thread.sleep(200L);
                    QueueSession s = this.val$mgr.getQueueSession();
                    Queue q = s.getQueue("queue1");
                    Serializable o = q.take();
                    Assert.assertEquals((String)"Queue content", (Object)"String1", (Object)o);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        t.start();
        QueueSession s = mgr.getQueueSession();
        Queue q = s.getQueue("queue1");
        Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
        q.put((Serializable)((Object)"String1"));
        q.put((Serializable)((Object)"String2"));
        latch.countDown();
        long t0 = System.currentTimeMillis();
        q.put((Serializable)((Object)"String3"));
        long t1 = System.currentTimeMillis();
        t.join();
        Assert.assertEquals((String)"Queue size", (long)2L, (long)q.size());
        Assert.assertTrue((t1 - t0 > 100L ? 1 : 0) != 0);
        mgr.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutWithPersistence() throws Exception {
        if (this.isPersistent()) {
            Queue q;
            QueueSession s;
            AbstractQueueManager mgr = this.createQueueManager();
            try {
                s = mgr.getQueueSession();
                mgr.start();
                q = s.getQueue("queue1");
                q.put((Serializable)((Object)"String1"));
                Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
                q = s.getQueue("queue1");
                Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
            }
            finally {
                mgr.stop();
                mgr.dispose();
            }
            mgr = this.createQueueManager();
            try {
                s = mgr.getQueueSession();
                mgr.start();
                q = s.getQueue("queue1");
                Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
            }
            finally {
                mgr.stop();
                mgr.dispose();
            }
        }
        this.logger.info("Ignoring test because queue manager is not persistent");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransactedPutCommitWithPersistence() throws Exception {
        if (this.isPersistent()) {
            AbstractQueueManager mgr = this.createQueueManager();
            try {
                QueueSession s = mgr.getQueueSession();
                Queue q = s.getQueue("queue1");
                mgr.start();
                s.begin();
                q.put((Serializable)((Object)"String1"));
                Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
                s.commit();
                Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
                s = mgr.getQueueSession();
                q = s.getQueue("queue1");
                Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
                mgr.stop();
                mgr = this.createQueueManager();
                s = mgr.getQueueSession();
                q = s.getQueue("queue1");
                mgr.start();
                Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
            }
            finally {
                mgr.stop();
                mgr.dispose();
            }
        } else {
            this.logger.info("Ignoring test because queue manager is not persistent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransactedPutRollbackWithPersistence() throws Exception {
        if (this.isPersistent()) {
            AbstractQueueManager mgr = this.createQueueManager();
            try {
                mgr.start();
                QueueSession s = mgr.getQueueSession();
                Queue q = s.getQueue("queue1");
                s.begin();
                q.put((Serializable)((Object)"String1"));
                Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
                s.rollback();
                Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
                s = mgr.getQueueSession();
                q = s.getQueue("queue1");
                Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
                mgr.stop();
                mgr = this.createQueueManager();
                mgr.start();
                s = mgr.getQueueSession();
                q = s.getQueue("queue1");
                Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
            }
            finally {
                mgr.stop();
                mgr.dispose();
            }
        } else {
            this.logger.info("Ignoring test because queue manager is not persistent");
        }
    }

    @Test
    public void testPutTake_RespectsOrderOnPersistence() throws Exception {
        if (this.isPersistent()) {
            AbstractQueueManager mgr1 = this.createQueueManager();
            QueueSession s1 = mgr1.getQueueSession();
            Queue q1 = s1.getQueue("queue1");
            mgr1.start();
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q1.size());
            int numberOfElements = 10;
            for (int i = 1; i <= 10; ++i) {
                q1.put((Serializable)((Object)("String" + i)));
                Assert.assertEquals((String)"Queue size", (long)i, (long)q1.size());
            }
            mgr1.stop();
            AbstractQueueManager mgr2 = this.createQueueManager();
            QueueSession s2 = mgr2.getQueueSession();
            Queue q2 = s2.getQueue("queue1");
            mgr2.start();
            for (int i = 1; i <= 10; ++i) {
                Serializable o = q2.take();
                Assert.assertNotNull((Object)o);
                Assert.assertEquals((String)"Queue content", (Object)("String" + i), (Object)o);
            }
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q2.size());
            mgr2.stop();
            mgr2.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransactionsOnMultipleQueues() throws Exception {
        AbstractQueueManager mgr = this.createQueueManager();
        try {
            mgr.start();
            QueueSession s1 = mgr.getQueueSession();
            QueueSession s2 = mgr.getQueueSession();
            Queue q1s1 = s1.getQueue("queue1");
            Queue q1s2 = s2.getQueue("queue1");
            Queue q2s1 = s1.getQueue("queue2");
            Queue q2s2 = s2.getQueue("queue2");
            q1s1.put((Serializable)((Object)"String1"));
            Assert.assertEquals((String)"Queue size", (long)1L, (long)q1s1.size());
            Assert.assertEquals((String)"Queue size", (long)1L, (long)q1s2.size());
            s1.begin();
            Serializable o = q1s1.take();
            Assert.assertNotNull((Object)o);
            Assert.assertEquals((Object)"String1", (Object)o);
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q1s1.size());
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q1s2.size());
            q2s1.put((Serializable)((Object)"String2"));
            Assert.assertEquals((String)"Queue size", (long)1L, (long)q2s1.size());
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q2s2.size());
            s1.commit();
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q1s1.size());
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q1s2.size());
            Assert.assertEquals((String)"Queue size", (long)1L, (long)q2s1.size());
            Assert.assertEquals((String)"Queue size", (long)1L, (long)q2s2.size());
            s1.begin();
            o = q2s1.take();
            Assert.assertNotNull((Object)o);
            Assert.assertEquals((Object)"String2", (Object)o);
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q1s1.size());
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q1s2.size());
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q2s1.size());
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q2s2.size());
            q1s1.put((Serializable)((Object)"String1"));
            Assert.assertEquals((String)"Queue size", (long)1L, (long)q1s1.size());
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q1s2.size());
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q2s1.size());
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q2s2.size());
            s1.rollback();
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q1s1.size());
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q1s2.size());
            Assert.assertEquals((String)"Queue size", (long)1L, (long)q2s1.size());
            Assert.assertEquals((String)"Queue size", (long)1L, (long)q2s2.size());
        }
        finally {
            mgr.stop();
            mgr.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPoll() throws Exception {
        AbstractQueueManager mgr = this.createQueueManager();
        try {
            mgr.start();
            QueueSession s = mgr.getQueueSession();
            Queue q = s.getQueue("queue1");
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
            Serializable o = q.poll(0L);
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
            Assert.assertNull((Object)o);
            o = q.poll(1000L);
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
            Assert.assertNull((Object)o);
            q.put((Serializable)((Object)"String1"));
            Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
            o = q.poll(0L);
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
            Assert.assertEquals((String)"Queue content", (Object)"String1", (Object)o);
            Latch putExecutionLatch = new Latch();
            Thread putExecutionThread = new Thread(() -> this.lambda$testPoll$0((QueueManager)mgr, putExecutionLatch));
            putExecutionThread.start();
            if (!putExecutionLatch.await(2000L, TimeUnit.MILLISECONDS)) {
                Assert.fail((String)"Thread executing put over queue was not executed");
            }
            o = q.poll(5000L);
            putExecutionThread.join(2000L);
            Assert.assertEquals((String)"Queue size", (long)q.size(), (long)0L);
            Assert.assertEquals((String)"Queue content", (Object)"String1", (Object)o);
        }
        finally {
            mgr.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPeek() throws Exception {
        AbstractQueueManager mgr = this.createQueueManager();
        try {
            mgr.start();
            QueueSession s = mgr.getQueueSession();
            Queue q = s.getQueue("queue1");
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
            Serializable o = q.peek();
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
            Assert.assertNull((Object)o);
            q.put((Serializable)((Object)"String1"));
            Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
            o = q.peek();
            Assert.assertEquals((String)"Queue size", (long)1L, (long)q.size());
            Assert.assertEquals((String)"Queue content", (Object)"String1", (Object)o);
            o = q.poll(1000L);
            Assert.assertEquals((String)"Queue size", (long)0L, (long)q.size());
            Assert.assertEquals((String)"Queue content", (Object)"String1", (Object)o);
        }
        finally {
            mgr.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOffer() throws Exception {
        AbstractQueueManager mgr = this.createQueueManager();
        mgr.setDefaultQueueConfiguration((QueueConfiguration)new DefaultQueueConfiguration(1, false));
        try {
            mgr.start();
            QueueSession s = mgr.getQueueSession();
            Queue q = s.getQueue("queue1");
            Assert.assertThat((String)"Queue size", (Object)q.size(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)q.offer((Serializable)((Object)"String1"), 0L), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((String)"Queue size", (Object)q.size(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)q.offer((Serializable)((Object)"String2"), 1000L), (Matcher)CoreMatchers.is((Object)false));
            Assert.assertThat((String)"Queue size", (Object)q.size(), (Matcher)CoreMatchers.is((Object)1));
            Latch takeExecutionLatch = new Latch();
            Thread takeExecutionThread = new Thread(() -> this.lambda$testOffer$1(takeExecutionLatch, (QueueManager)mgr));
            takeExecutionThread.start();
            if (!takeExecutionLatch.await(2000L, TimeUnit.MILLISECONDS)) {
                Assert.fail((String)"Thread executing put over queue was not executed");
            }
            Assert.assertThat((Object)q.offer((Serializable)((Object)"String2"), 1000L), (Matcher)CoreMatchers.is((Object)true));
            takeExecutionThread.join(2000L);
            Assert.assertThat((String)"Queue size", (Object)q.size(), (Matcher)CoreMatchers.is((Object)1));
        }
        finally {
            mgr.stop();
        }
    }

    @Test
    public void testRecoverWarmRestart() throws Exception {
        AbstractQueueManager mgr = this.createQueueManager();
        mgr.start();
        QueueSession s = mgr.getQueueSession();
        Queue q = s.getQueue("warmRecoverQueue");
        int toPopulate = 50;
        Random rnd = new Random();
        for (int j = 0; j < toPopulate; ++j) {
            byte[] o = new byte[2048];
            rnd.nextBytes(o);
            q.put((Serializable)o);
        }
        Assert.assertEquals((long)q.size(), (long)toPopulate);
        mgr.stop();
        mgr.start();
        Assert.assertEquals((long)toPopulate, (long)q.size());
    }

    @Test
    public void testRecoverColdRestart() throws Exception {
        AbstractQueueManager mgr = this.createQueueManager();
        QueueSession s = mgr.getQueueSession();
        Queue q = s.getQueue("warmRecoverQueue");
        mgr.start();
        int toPopulate = 50;
        Random rnd = new Random();
        for (int j = 0; j < toPopulate; ++j) {
            byte[] o = new byte[2048];
            rnd.nextBytes(o);
            q.put((Serializable)o);
        }
        Assert.assertEquals((long)toPopulate, (long)q.size());
        mgr.stop();
        mgr = this.createQueueManager();
        s = mgr.getQueueSession();
        q = s.getQueue("warmRecoverQueue");
        mgr.start();
        if (this.isPersistent()) {
            Assert.assertEquals((long)toPopulate, (long)q.size());
        } else {
            Assert.assertEquals((long)0L, (long)q.size());
        }
    }

    @Test
    public void testDisposeQueueWithoutTransaction() throws Exception {
        this.disposeTest.testDisposal((QueueManager)this.createQueueManager(), false);
    }

    @Test
    public void testDisposeQueueInTransaction() throws Exception {
        this.disposeTest.testDisposal((QueueManager)this.createQueueManager(), true);
    }

    @Test
    public void testDisposeQueueByNameInTransaction() throws Exception {
        this.disposeTest.testDisposal((QueueManager)this.createQueueManager(), true);
    }

    private /* synthetic */ void lambda$testOffer$1(Latch takeExecutionLatch, QueueManager mgr) {
        try {
            takeExecutionLatch.release();
            QueueSession s1 = mgr.getQueueSession();
            Queue q1 = s1.getQueue("queue1");
            Assert.assertThat((String)"Queue content", (Object)q1.take(), (Matcher)CoreMatchers.is((Object)"String1"));
        }
        catch (Exception e) {
            this.logger.warn("Error using queue session", (Throwable)e);
        }
    }

    private /* synthetic */ void lambda$testPoll$0(QueueManager mgr, Latch putExecutionLatch) {
        try {
            QueueSession s1 = mgr.getQueueSession();
            Queue q1 = s1.getQueue("queue1");
            putExecutionLatch.release();
            q1.put((Serializable)((Object)"String1"));
        }
        catch (Exception e) {
            this.logger.warn("Error using queue session", (Throwable)e);
        }
    }
}

