/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.testmodels.mule;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.exception.RollbackSourceCallback;
import org.mule.runtime.core.api.exception.SystemExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestExceptionStrategy
implements MessagingExceptionHandler,
SystemExceptionHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Object callbackLock = new Object();
    private ExceptionCallback callback;
    private List<Exception> unhandled = new LinkedList<Exception>();
    private volatile String testProperty;

    public String getTestProperty() {
        return this.testProperty;
    }

    public void setTestProperty(String testProperty) {
        this.testProperty = testProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalEvent handleException(Exception exception, InternalEvent event, RollbackSourceCallback rollbackMethod) {
        ExceptionCallback callback = null;
        Object object = this.callbackLock;
        synchronized (object) {
            if (this.callback != null) {
                callback = this.callback;
            } else {
                this.unhandled.add(exception);
            }
        }
        this.logger.info("Handling exception: " + exception.getClass().getName());
        if (callback != null) {
            this.logger.info("Exception caught on TestExceptionStrategy and was sent to callback.", (Throwable)exception);
            callback.onException(exception);
        } else {
            this.logger.info("Exception caught on TestExceptionStrategy but there was no callback set.", (Throwable)exception);
        }
        return event;
    }

    public InternalEvent handleException(MessagingException exception, InternalEvent event) {
        return this.handleException((Exception)exception, event, null);
    }

    public void handleException(Exception exception, RollbackSourceCallback rollbackMethod) {
        this.handleException(exception, null, rollbackMethod);
    }

    public void handleException(Exception exception) {
        this.handleException(exception, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExceptionCallback(ExceptionCallback exceptionCallback) {
        Object object = this.callbackLock;
        synchronized (object) {
            this.callback = exceptionCallback;
        }
        this.processUnhandled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processUnhandled() {
        ArrayList<Exception> unhandledCopies = null;
        ExceptionCallback callback = null;
        Iterator iterator = this.callbackLock;
        synchronized (iterator) {
            if (this.callback != null) {
                callback = this.callback;
                unhandledCopies = new ArrayList<Exception>(this.unhandled);
                this.unhandled.clear();
            }
        }
        if (callback != null && unhandledCopies != null) {
            for (Exception exception : unhandledCopies) {
                this.logger.info("Handling exception after setting the callback.", (Throwable)exception);
                callback.onException(exception);
            }
        }
    }

    public static interface ExceptionCallback {
        public void onException(Throwable var1);
    }
}

