/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4.matcher;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.mule.runtime.core.api.functional.Either;

public class EitherMatcher<L, R>
extends TypeSafeMatcher<Either<L, R>> {
    private Matcher<L> leftMatcher;
    private Matcher<R> rightMatcher;

    public EitherMatcher(Matcher<L> leftMatcher, Matcher<R> rightMatcher) {
        this.leftMatcher = leftMatcher;
        this.rightMatcher = rightMatcher;
    }

    public static <L, R> EitherMatcher<L, R> leftMatches(Matcher<L> matcher) {
        return new EitherMatcher<L, R>(matcher, Matchers.nullValue());
    }

    public static <L, R> EitherMatcher<L, R> rightMatches(Matcher<R> matcher) {
        return new EitherMatcher<L, R>(Matchers.nullValue(), matcher);
    }

    protected boolean matchesSafely(Either<L, R> item) {
        return this.leftMatcher.matches(item.getLeft()) && this.rightMatcher.matches(item.getRight());
    }

    public void describeTo(Description description) {
        description.appendText("left is ");
        this.leftMatcher.describeTo(description);
        description.appendText("; and right is ");
        this.rightMatcher.describeTo(description);
    }
}

