/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.core.util.queue;

import java.io.Serializable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.mule.runtime.api.queue.Queue;
import org.mule.runtime.api.queue.QueueManager;
import org.mule.runtime.api.queue.QueueSession;

public class QueueTestComponent {
    public void testDisposal(QueueManager mgr, boolean transactional) throws Exception {
        String queueName = "myQueue";
        mgr.start();
        QueueSession session = mgr.getQueueSession();
        if (transactional) {
            session.begin();
        }
        Queue queue = mgr.getQueueSession().getQueue("myQueue");
        this.assertQueueDisposal(mgr, queue, (QueueSession)(transactional ? session : null), "myQueue");
    }

    private void assertQueueDisposal(QueueManager mgr, Queue queue, QueueSession session, String queueName) throws Exception {
        queue.put((Serializable)((Object)"some value"));
        Assert.assertEquals((long)1L, (long)queue.size());
        if (session != null) {
            session.commit();
        }
        queue.dispose();
        Queue queue2 = mgr.getQueueSession().getQueue(queueName);
        MatcherAssert.assertThat((Object)queue, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)queue2)));
        MatcherAssert.assertThat((Object)queue2.size(), (Matcher)Is.is((Object)0));
    }
}

