/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.mule.runtime.core.api.util.compression.InvalidZipFileException;

public class FileUtils {
    private static Collection<File> findFiles(File folder, IOFileFilter filter, boolean recursive) {
        return org.apache.commons.io.FileUtils.listFiles((File)folder, (IOFileFilter)filter, (IOFileFilter)(recursive ? TrueFileFilter.INSTANCE : FalseFileFilter.INSTANCE));
    }

    public static File findFileByName(File folder, final String filename) {
        Collection<File> files = FileUtils.findFiles(folder, new IOFileFilter(){

            public boolean accept(File file) {
                return filename.equals(file.getName());
            }

            public boolean accept(File dir, String name) {
                return true;
            }
        }, true);
        return files.isEmpty() ? null : files.iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File archive, File directory) throws IOException {
        ZipFile zip = null;
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new IOException("Directory is not a directory: " + String.valueOf(directory));
            }
        } else if (!directory.mkdirs()) {
            throw new IOException("Could not create directory: " + String.valueOf(directory));
        }
        try {
            zip = new ZipFile(archive);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File file = FileUtils.verifyZipEntryPath(directory, entry);
                if (entry.isDirectory()) {
                    if (file.exists() || file.mkdirs()) continue;
                    throw new IOException("Could not create directory: " + String.valueOf(file));
                }
                if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                    throw new IOException("Unable to create folders for zip entry: " + entry.getName());
                }
                InputStream is = zip.getInputStream(entry);
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
                try {
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                    IOUtils.closeQuietly((OutputStream)os);
                }
            }
        }
        finally {
            if (zip != null) {
                zip.close();
            }
        }
    }

    private static File verifyZipEntryPath(File targetDirectory, ZipEntry entry) throws IOException {
        Path namePath = Paths.get(entry.getName(), new String[0]);
        if (namePath.getRoot() != null) {
            throw new InvalidZipFileException("Absolute paths are not allowed: " + namePath.toString());
        }
        File targetFile = new File(targetDirectory, entry.getName());
        if (!targetFile.getCanonicalPath().startsWith(targetDirectory.getCanonicalPath())) {
            throw new InvalidZipFileException("External paths are not allowed: " + namePath.toString());
        }
        return targetFile;
    }

    private FileUtils() {
    }
}

