/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tck.junit5;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.junit.jupiter.api.extension.ExtendWith;

/**
 * Annotation to inject a dynamic port number into test method attributes. The port will be automatically allocated and released
 * after the test. A system property will be set during the test with the specified name, and the previous property value will be
 * restored when the test ends.
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
@ExtendWith(DynamicPortExtension.class)
public @interface DynamicPort {

  /**
   * The name for the system property that will be set with the port number.
   *
   * @return the system property name.
   */
  String systemProperty();
}
