/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4.matcher;

import java.util.concurrent.TimeUnit;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.mule.tck.probe.Timeout;

public class Eventually<T>
extends BaseMatcher<T> {
    private final Matcher<T> matcher;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private int time = 10;
    private long interval = 1000L;

    public static <T> Eventually<T> eventually(Matcher<T> matcher) {
        return new Eventually<T>(matcher);
    }

    private Eventually(Matcher<T> matcher) {
        this.matcher = matcher;
    }

    public Eventually<T> atMostIn(int time, TimeUnit timeUnit) {
        this.time = time;
        this.timeUnit = timeUnit;
        return this;
    }

    public Eventually<T> every(int time, TimeUnit timeUnit) {
        this.interval = timeUnit.toMillis(time);
        return this;
    }

    public boolean matches(Object item) {
        Timeout timeout = new Timeout(this.timeUnit.toMillis(this.time));
        while (!this.matcher.matches(item)) {
            if (timeout.hasTimedOut()) {
                return false;
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                new RuntimeException("Interrupted while waiting for condition", e);
            }
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("after " + this.time + " " + this.timeUnit.toString() + "s ").appendDescriptionOf(this.matcher);
    }
}

