/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit5;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResourceExtension<A extends Annotation, V>
implements BeforeEachCallback,
AfterEachCallback,
BeforeAllCallback,
AfterAllCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractResourceExtension.class);
    private final Class<? extends Annotation> annotationClass;

    protected AbstractResourceExtension(Class<? extends A> annotationClass) {
        this.annotationClass = annotationClass;
    }

    protected abstract V createResource(A var1);

    protected abstract void disposeResource(A var1, V var2);

    public void beforeEach(ExtensionContext context) throws Exception {
        this.iterateAnnotatedFields(context, this::setField, false);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.iterateAnnotatedFields(context, this::unsetField, false);
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.iterateAnnotatedFields(context, this::setField, true);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.iterateAnnotatedFields(context, this::unsetField, true);
    }

    private void setField(Annotation annotation, Object instance, Field field) throws IllegalAccessException {
        LOGGER.debug("About to set field '{}' annotated with '{}'", (Object)field, (Object)annotation);
        field.set(instance, this.createResource(annotation));
    }

    private void unsetField(Annotation annotation, Object instance, Field field) throws IllegalAccessException {
        LOGGER.debug("About to clear field '{}' annotated with '{}'", (Object)field, (Object)annotation);
        this.disposeResource(annotation, field.get(instance));
    }

    private void iterateAnnotatedFields(ExtensionContext context, TriConsumer<Annotation, Object, Field> callback, boolean processStatic) throws Exception {
        Object testInstance = context.getTestInstance().orElse(null);
        for (Class testClass = context.getRequiredTestClass(); testClass != Object.class; testClass = testClass.getSuperclass()) {
            for (Field field : testClass.getDeclaredFields()) {
                Annotation annotation = field.getAnnotation(this.annotationClass);
                if (annotation == null || Modifier.isStatic(field.getModifiers()) != processStatic) continue;
                field.setAccessible(true);
                callback.accept(annotation, testInstance, field);
            }
        }
    }

    private static interface TriConsumer<A, B, C> {
        public void accept(A var1, B var2, C var3) throws Exception;
    }
}

