/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.core.util.store;

import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.store.ObjectAlreadyExistsException;
import org.mule.runtime.api.store.ObjectDoesNotExistException;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public abstract class TemplateObjectStoreContractTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testContainsWithNullKey() {
        try {
            this.getObjectStore().contains(null);
            Assert.fail((String)"contains() called with null key must throw ObjectStoreException");
        }
        catch (ObjectStoreException objectStoreException) {
            // empty catch block
        }
    }

    @Test
    public void testStoreWithNullKey() {
        try {
            Serializable value = this.getStorableValue();
            this.getObjectStore().store(null, value);
            Assert.fail((String)"store() called with null key must throw ObjectStoreException");
        }
        catch (ObjectStoreException objectStoreException) {
            // empty catch block
        }
    }

    @Test
    public void testRetrieveWithNullKey() {
        try {
            this.getObjectStore().retrieve(null);
            Assert.fail((String)"retrieve() called with null key must throw ObjectStoreException");
        }
        catch (ObjectStoreException objectStoreException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveWithNullKey() {
        try {
            this.getObjectStore().remove(null);
            Assert.fail((String)"remove() called with null key must throw ObjectStoreException");
        }
        catch (ObjectStoreException objectStoreException) {
            // empty catch block
        }
    }

    @Test
    public void testRetrieveUnboundKey() throws ObjectStoreException {
        try {
            String key = this.createKey();
            this.getObjectStore().retrieve(key);
            Assert.fail((String)"retrieve() with unbound key must throw ObjectDoesNotExistException");
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveWithUnboundKey() throws ObjectStoreException {
        try {
            String key = this.createKey();
            this.getObjectStore().remove(key);
            Assert.fail((String)"remove() with unbound key must throw ObjectDoesNotExistException");
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            // empty catch block
        }
    }

    @Test
    public void clear() throws ObjectStoreException {
        String key = this.createKey();
        Serializable value = this.getStorableValue();
        ObjectStore<Serializable> objectStore = this.getObjectStore();
        objectStore.store(key, value);
        junit.framework.Assert.assertTrue((boolean)objectStore.contains(key));
        objectStore.clear();
        junit.framework.Assert.assertFalse((boolean)objectStore.contains(key));
        objectStore.store(key, value);
        junit.framework.Assert.assertTrue((boolean)objectStore.contains(key));
    }

    @Test
    public void testStoreWithExistingKey() throws ObjectStoreException {
        String key = this.createKey();
        Serializable value = this.getStorableValue();
        ObjectStore<Serializable> objectStore = this.getObjectStore();
        objectStore.store(key, value);
        try {
            objectStore.store(key, value);
            Assert.fail((String)"store() with an existing key must throw ObjectAlreadyExistsException");
        }
        catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
            // empty catch block
        }
    }

    protected String createKey() {
        return "theKey";
    }

    public abstract ObjectStore<Serializable> getObjectStore() throws ObjectStoreException;

    public abstract Serializable getStorableValue();
}

