/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit5;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.tck.junit4.rule.FreePortFinder;
import org.mule.tck.junit5.AbstractResourceExtension;
import org.mule.tck.junit5.DynamicPort;

public class DynamicPortExtension
extends AbstractResourceExtension<DynamicPort, Integer> {
    public static final String MIN_PORT_SYSTEM_PROPERTY = "mule.test.minPort";
    public static final String MAX_PORT_SYSTEM_PROPERTY = "mule.test.maxPort";
    private static final int DEFAULT_MIN_PORT = 10000;
    private static final int DEFAULT_MAX_PORT = 40000;
    protected static FreePortFinder freePortFinder;
    private final Map<String, String> propertiesToRestore = new ConcurrentHashMap<String, String>();

    public DynamicPortExtension() {
        super(DynamicPort.class);
    }

    @Override
    protected Integer createResource(DynamicPort annotation) {
        String systemProperty = annotation.systemProperty();
        String oldPropertyValue = System.getProperty(systemProperty);
        if (oldPropertyValue != null) {
            this.propertiesToRestore.put(systemProperty, oldPropertyValue);
        }
        Integer portNumber = freePortFinder.find();
        System.setProperty(systemProperty, String.valueOf(portNumber));
        return portNumber;
    }

    @Override
    protected void disposeResource(DynamicPort annotation, Integer portNumber) {
        String systemProperty = annotation.systemProperty();
        String oldValue = this.propertiesToRestore.remove(systemProperty);
        if (oldValue != null) {
            System.setProperty(systemProperty, oldValue);
        } else {
            System.clearProperty(systemProperty);
        }
        freePortFinder.releasePort(portNumber);
    }

    static {
        int minPort = 10000;
        int maxPort = 40000;
        String propertyValue = System.getProperty(MIN_PORT_SYSTEM_PROPERTY);
        if (propertyValue != null) {
            minPort = Integer.parseInt(propertyValue);
        }
        if ((propertyValue = System.getProperty(MAX_PORT_SYSTEM_PROPERTY)) != null) {
            maxPort = Integer.parseInt(propertyValue);
        }
        if (minPort > maxPort) {
            throw new IllegalArgumentException(String.format("Min port '%s' must be less than max port '%s'", minPort, maxPort));
        }
        freePortFinder = new FreePortFinder(minPort, maxPort);
    }
}

