/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.builder;

import com.google.common.base.Preconditions;
import com.vdurmont.semver4j.Semver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.module.artifact.builder.AbstractDependencyFileBuilder;
import org.mule.runtime.module.artifact.builder.TestArtifactDescriptor;
import org.mule.tck.ZipUtils;

public abstract class AbstractArtifactFileBuilder<T extends AbstractArtifactFileBuilder<T>>
extends AbstractDependencyFileBuilder<T>
implements TestArtifactDescriptor {
    protected static final String CLASSLOADER_MODEL_JSON_DESCRIPTOR = "classloader-model.json";
    protected static final String CLASSLOADER_MODEL_JSON_DESCRIPTOR_LOCATION = Paths.get("META-INF", "mule-artifact", "classloader-model.json").toString();
    protected static final Semver CLASS_LOADER_MODEL_VERSION_110 = new Semver("1.1.0", Semver.SemverType.LOOSE);
    protected static final String CLASS_LOADER_MODEL_VERSION_120 = "1.2.0";
    private final boolean upperCaseInExtension;
    protected File artifactFile;
    protected List<ZipUtils.ZipResource> resources = new LinkedList<ZipUtils.ZipResource>();
    protected boolean corrupted;

    public AbstractArtifactFileBuilder(String artifactId, boolean upperCaseInExtension) {
        super(artifactId);
        this.upperCaseInExtension = upperCaseInExtension;
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)artifactId) ? 1 : 0) != 0, (Object)"ID cannot be empty");
    }

    public AbstractArtifactFileBuilder(String artifactId) {
        this(artifactId, false);
    }

    protected String getFileExtension() {
        return ".jar";
    }

    public AbstractArtifactFileBuilder(T source) {
        this(((AbstractArtifactFileBuilder)source).getArtifactId(), source);
    }

    public AbstractArtifactFileBuilder(String id, T source) {
        this(id);
        this.resources.addAll(((AbstractArtifactFileBuilder)source).resources);
        this.corrupted = ((AbstractArtifactFileBuilder)source).corrupted;
    }

    public T usingResource(String resourceFile, String targetFile) {
        this.checkImmutable();
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)resourceFile) ? 1 : 0) != 0, (Object)"Resource file cannot be empty");
        this.resources.add(new ZipUtils.ZipResource(resourceFile, targetFile));
        return (T)((AbstractArtifactFileBuilder)this.getThis());
    }

    public T usingLibrary(String jarFile) {
        this.checkImmutable();
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)jarFile) ? 1 : 0) != 0, (Object)"Jar file cannot be empty");
        this.resources.add(new ZipUtils.ZipResource(jarFile, "lib/" + FilenameUtils.getName((String)jarFile)));
        return (T)((AbstractArtifactFileBuilder)this.getThis());
    }

    public T usingLibraries(File ... jarFiles) {
        this.checkImmutable();
        for (File jarFile : jarFiles) {
            Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)jarFile.getAbsolutePath()) ? 1 : 0) != 0, (Object)"Jar file cannot be empty");
            this.resources.add(new ZipUtils.ZipResource(jarFile.getAbsolutePath(), "lib/" + FilenameUtils.getName((String)jarFile.getAbsolutePath())));
        }
        return (T)((AbstractArtifactFileBuilder)this.getThis());
    }

    public T containingClass(File classFile, String alias) {
        this.checkImmutable();
        Objects.requireNonNull(classFile, "Class file cannot be null");
        this.resources.add(new ZipUtils.ZipResource(classFile.getAbsolutePath(), alias));
        return (T)((AbstractArtifactFileBuilder)this.getThis());
    }

    public T containingResource(String resourceFile, String alias) {
        this.checkImmutable();
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)resourceFile) ? 1 : 0) != 0, (Object)"Resource file cannot be empty");
        this.resources.add(new ZipUtils.ZipResource(resourceFile, alias));
        return (T)((AbstractArtifactFileBuilder)this.getThis());
    }

    public T corrupted() {
        this.checkImmutable();
        this.corrupted = true;
        return (T)((AbstractArtifactFileBuilder)this.getThis());
    }

    @Override
    public String getId() {
        return FilenameUtils.getBaseName((String)this.getArtifactFileName());
    }

    @Override
    public String getZipPath() {
        if (this.artifactFile == null) {
            throw new IllegalStateException("Must generate the artifact file before invoking this method");
        }
        return File.separator + this.artifactFile.getName();
    }

    @Override
    public String getDeployedPath() {
        if (this.artifactFile == null) {
            throw new IllegalStateException("Must generate the artifact file before invoking this method");
        }
        if (this.corrupted) {
            return this.artifactFile.getName();
        }
        return FilenameUtils.getBaseName((String)this.artifactFile.getName());
    }

    @Override
    public File getArtifactFile() {
        if (this.artifactFile == null) {
            String fileName = this.getArtifactFileName();
            File tempFile = new File(this.getTempFolder(), fileName);
            tempFile.deleteOnExit();
            if (this.corrupted) {
                this.buildBrokenJarFile(tempFile);
            } else {
                LinkedList<ZipUtils.ZipResource> zipResources = new LinkedList<ZipUtils.ZipResource>(this.resources);
                zipResources.add(new ZipUtils.ZipResource(this.getArtifactPomFile().getAbsolutePath(), this.getArtifactFileBundledPomPartialUrl()));
                zipResources.add(new ZipUtils.ZipResource(this.getArtifactPomPropertiesFile().getAbsolutePath(), this.getArtifactFileBundledPomPropertiesPartialUrl()));
                zipResources.addAll(this.getCustomResources());
                ZipUtils.compress(tempFile, zipResources.toArray(new ZipUtils.ZipResource[0]));
            }
            this.artifactFile = new File(tempFile.getAbsolutePath());
        }
        return this.artifactFile;
    }

    private String getArtifactFileName() {
        Object fileName = this.getArtifactId();
        String artifactNameSeparator = "-";
        if (this.getVersion() != null) {
            fileName = (String)fileName + artifactNameSeparator + this.getVersion();
        }
        if (this.getClassifier() != null) {
            fileName = (String)fileName + artifactNameSeparator + this.getClassifier();
        }
        fileName = (String)fileName + (this.upperCaseInExtension ? this.getFileExtension().toUpperCase() : this.getFileExtension().toLowerCase());
        return fileName;
    }

    protected final void checkImmutable() {
        MatcherAssert.assertThat((String)"Cannot change attributes once the artifact file was built", (Object)this.artifactFile, (Matcher)Is.is((Matcher)Matchers.nullValue()));
    }

    protected ZipUtils.ZipResource createPropertiesFile(Properties props, String propertiesFileName, String zipAlias) {
        ZipUtils.ZipResource result = null;
        if (!props.isEmpty()) {
            File applicationPropertiesFile = new File(this.getTempFolder(), propertiesFileName);
            applicationPropertiesFile.deleteOnExit();
            this.createPropertiesFile(applicationPropertiesFile, props);
            result = new ZipUtils.ZipResource(applicationPropertiesFile.getAbsolutePath(), zipAlias);
        }
        return result;
    }

    protected void createPropertiesFile(File file, Properties props) {
        try {
            FileOutputStream out = new FileOutputStream(file);
            props.store(out, "Generated application properties");
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create properties", e);
        }
    }

    private void buildBrokenJarFile(File tempFile) throws UncheckedIOException {
        try {
            FileUtils.write((File)tempFile, (CharSequence)"This content represents invalid compressed data");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected abstract List<ZipUtils.ZipResource> getCustomResources();

    protected Optional<MuleArtifactLoaderDescriptor> getBundleDescriptorLoader() {
        return Optional.empty();
    }

    @Override
    public String getGroupId() {
        return (String)this.getBundleDescriptorLoader().map(descriptorLoader -> descriptorLoader.getAttributes().get("groupId")).orElse(super.getGroupId());
    }

    @Override
    public String getArtifactId() {
        return (String)this.getBundleDescriptorLoader().map(descriptorLoader -> descriptorLoader.getAttributes().get("artifactId")).orElse(super.getArtifactId());
    }

    @Override
    public String getClassifier() {
        return (String)this.getBundleDescriptorLoader().map(descriptorLoader -> descriptorLoader.getAttributes().get("classifier")).orElse(super.getClassifier());
    }

    @Override
    public String getType() {
        return (String)this.getBundleDescriptorLoader().map(descriptorLoader -> descriptorLoader.getAttributes().get("type")).orElse(super.getType());
    }

    @Override
    public String getVersion() {
        return (String)this.getBundleDescriptorLoader().map(descriptorLoader -> descriptorLoader.getAttributes().get("version")).orElse(super.getVersion());
    }
}

