/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit5;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.mule.tck.junit5.SystemProperty;

public class SystemPropertyExtension
implements BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    private final String propertyName;
    private final String propertyValue;
    private String previousValue;
    private static final Map<String, String> ANNOTATION_PROPERTIES = new ConcurrentHashMap<String, String>();

    public SystemPropertyExtension() {
        this.propertyName = null;
        this.propertyValue = null;
    }

    public SystemPropertyExtension(String propertyName, String propertyValue) {
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
    }

    private void set() {
        this.previousValue = System.getProperty(this.propertyName);
        System.setProperty(this.propertyName, this.propertyValue);
    }

    private void unSet() {
        if (this.previousValue == null) {
            System.clearProperty(this.propertyName);
        } else {
            System.setProperty(this.propertyName, this.previousValue);
        }
    }

    public String getPropertyValue() {
        return this.propertyValue;
    }

    public String toString() {
        return "propertyName='" + this.propertyName + "', propertyValue='" + this.propertyValue + "'";
    }

    public void beforeEach(ExtensionContext context) {
        if (this.propertyName == null) {
            this.processAnnotations(context);
        } else {
            this.set();
        }
    }

    public void afterEach(ExtensionContext context) {
        if (this.propertyName == null) {
            this.clearAnnotations(context);
        } else {
            this.unSet();
        }
    }

    private void processAnnotations(ExtensionContext context) {
        SystemProperty[] annotations;
        for (SystemProperty annotation : annotations = this.findAnnotations(context)) {
            String name = annotation.name();
            String value = annotation.value();
            String previousValue = System.getProperty(name);
            if (previousValue != null) {
                ANNOTATION_PROPERTIES.put(name, previousValue);
            }
            System.setProperty(name, value);
        }
    }

    private void clearAnnotations(ExtensionContext context) {
        SystemProperty[] annotations;
        for (SystemProperty annotation : annotations = this.findAnnotations(context)) {
            String name = annotation.name();
            String previousValue = ANNOTATION_PROPERTIES.remove(name);
            if (previousValue != null) {
                System.setProperty(name, previousValue);
                continue;
            }
            System.clearProperty(name);
        }
    }

    private SystemProperty[] findAnnotations(ExtensionContext context) {
        return (SystemProperty[])context.getRequiredTestClass().getAnnotationsByType(SystemProperty.class);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return false;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return null;
    }
}

