/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tck.junit5;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.junit.jupiter.api.extension.ExtendWith;

/**
 * Container annotation for multiple {@link SystemProperty} annotations. This annotation is automatically used when
 * multiple @SystemProperty annotations are applied.
 *
 * <p>
 * Example usage:
 * </p>
 *
 * <pre>
 *
 * {
 *   &#64;code
 *   &#64;SystemProperties({
 *     &#64;SystemProperty(name = "my.property", value = "test-value")
 *     &#64;SystemProperty(name = "another.property", value = "another-value")
 *   })
 *   class MyTest {
 *     // tests here
 *   }
 * }
 * </pre>
 */
@Target({ElementType.TYPE, ElementType.METHOD, ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@ExtendWith(SystemPropertyExtension.class)
public @interface SystemProperties {

  /**
   * Array of {@link SystemProperty} annotations.
   */
  SystemProperty[] value();
}

