/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.report;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadDumper {
    private static final ThreadMXBean tmx = ManagementFactory.getThreadMXBean();
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadDumper.class);
    private final boolean useLogger;

    public ThreadDumper() {
        this(true);
    }

    public ThreadDumper(boolean useLogger) {
        this.useLogger = useLogger;
    }

    public void logThreadDump() {
        if (this.useLogger) {
            LOGGER.error(this.getThreadDump());
        } else {
            System.out.println(this.getThreadDump());
        }
    }

    private String getThreadDump() {
        return System.lineSeparator() + Arrays.stream(tmx.dumpAllThreads(true, true)).map(Object::toString).collect(Collectors.joining(System.lineSeparator()));
    }
}

