/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tck.junit4;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import org.junit.jupiter.api.RepeatedTest;

/**
 * Indicates that a test method or class is flaky
 *
 * @deprecated Use JUnit 5 {@link RepeatedTest} instead.
 */
@Deprecated
@Target({METHOD, TYPE})
@Retention(RUNTIME)
public @interface FlakyTest {

  /**
   * Indicate the number of times a flaky test must be executed.
   */
  int times() default 50;
}
