/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.transformer.simple;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.activation.MimeTypeParseException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.el.ExpressionManagerSession;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.api.util.SystemUtils;
import org.mule.runtime.core.api.util.func.CheckedRunnable;
import org.mule.runtime.core.privileged.processor.simple.AbstractAddVariablePropertyProcessor;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;
import org.mule.tck.size.SmallTest;
import org.mule.tck.util.MuleContextUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public abstract class AbstractAddVariablePropertyProcessorTestCase
extends AbstractMuleContextTestCase {
    public static final Charset ENCODING = StandardCharsets.US_ASCII;
    public static final String PLAIN_STRING_KEY = "someText";
    public static final String PLAIN_STRING_VALUE = "someValue";
    public static final String EXPRESSION = "#['someValue']";
    public static final String EXPRESSION_VALUE = "expressionValueResult";
    public static final String NULL_EXPRESSION = "#['someValueNull']";
    public static final Charset CUSTOM_ENCODING = StandardCharsets.UTF_8;
    @Mock
    private MuleContext mockMuleContext;
    @Mock(lenient=true)
    private StreamingManager streamingManager;
    @Mock
    private ExtendedExpressionManager mockExpressionManager;
    private CoreEvent event;
    private Message message;
    private TypedValue typedValue;
    private AbstractAddVariablePropertyProcessor addVariableProcessor;
    private ExpressionManagerSession mockSession;
    private CheckedRunnable afterAssertions;

    public AbstractAddVariablePropertyProcessorTestCase(AbstractAddVariablePropertyProcessor abstractAddVariableProcessor) {
        this.addVariableProcessor = abstractAddVariableProcessor;
    }

    @Before
    public void setUpTest() throws Exception {
        Mockito.when((Object)this.mockMuleContext.getExpressionManager()).thenReturn((Object)this.mockExpressionManager);
        Mockito.when((Object)this.mockMuleContext.getConfiguration()).thenReturn(Mockito.mock(MuleConfiguration.class));
        this.typedValue = new TypedValue((Object)EXPRESSION_VALUE, DataType.STRING);
        this.mockSession = (ExpressionManagerSession)Mockito.mock(ExpressionManagerSession.class);
        Mockito.when((Object)this.mockExpressionManager.openSession((ComponentLocation)ArgumentMatchers.any(), (CoreEvent)ArgumentMatchers.any(), (BindingContext)ArgumentMatchers.any())).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockSession.evaluate((String)ArgumentMatchers.eq((Object)EXPRESSION), (DataType)ArgumentMatchers.eq((Object)DataType.STRING))).thenReturn((Object)this.typedValue);
        Mockito.when((Object)this.mockSession.evaluate((String)ArgumentMatchers.eq((Object)EXPRESSION))).thenReturn((Object)this.typedValue);
        Mockito.when((Object)this.streamingManager.manage((CursorProvider)ArgumentMatchers.any(CursorProvider.class), (EventContext)ArgumentMatchers.any(EventContext.class))).thenAnswer(inv -> inv.getArgument(0));
        this.addVariableProcessor.setMuleContext(this.mockMuleContext);
        this.addVariableProcessor.setStreamingManager(this.streamingManager);
        this.message = Message.of((Object)"");
        this.event = this.createTestEvent(this.message);
        this.afterAssertions = () -> ((StreamingManager)Mockito.verify((Object)this.streamingManager, (VerificationMode)Mockito.never())).manage((CursorProvider)ArgumentMatchers.any(CursorProvider.class), (EventContext)ArgumentMatchers.any(EventContext.class));
    }

    @After
    public void after() {
        if (this.afterAssertions != null) {
            this.afterAssertions.run();
        }
    }

    protected CoreEvent createTestEvent(Message message) throws MuleException {
        return MuleContextUtils.eventBuilder(muleContext).message(message).build();
    }

    @Test
    public void testAddVariable() throws MuleException {
        this.addVariableProcessor.setIdentifier(PLAIN_STRING_KEY);
        this.addVariableProcessor.setValue(PLAIN_STRING_VALUE);
        this.addVariableProcessor.initialise();
        this.event = this.addVariableProcessor.process(this.event);
        this.verifyAdded(this.event, PLAIN_STRING_KEY, PLAIN_STRING_VALUE);
        Assert.assertThat((Object)this.getVariableDataType(this.event, PLAIN_STRING_KEY), DataTypeMatcher.like(String.class, MediaType.ANY, SystemUtils.getDefaultEncoding((MuleContext)this.mockMuleContext)));
    }

    @Test
    public void testAddVariableWithExpressionValue() throws MuleException {
        this.addVariableProcessor.setIdentifier(PLAIN_STRING_KEY);
        this.addVariableProcessor.setValue(EXPRESSION);
        this.addVariableProcessor.initialise();
        this.event = this.addVariableProcessor.process(this.event);
        this.verifyAdded(this.event, PLAIN_STRING_KEY, EXPRESSION_VALUE);
        Assert.assertThat((Object)this.getVariableDataType(this.event, PLAIN_STRING_KEY), DataTypeMatcher.like(String.class, MediaType.ANY, SystemUtils.getDefaultEncoding((MuleContext)this.mockMuleContext)));
    }

    @Test
    public void testAddVariableWithExpressionKey() throws MuleException {
        this.addVariableProcessor.setIdentifier(EXPRESSION);
        this.addVariableProcessor.setValue(PLAIN_STRING_VALUE);
        this.addVariableProcessor.initialise();
        this.event = this.addVariableProcessor.process(this.event);
        this.verifyAdded(this.event, EXPRESSION_VALUE, PLAIN_STRING_VALUE);
        Assert.assertThat((Object)this.getVariableDataType(this.event, EXPRESSION_VALUE), DataTypeMatcher.like(String.class, MediaType.ANY, SystemUtils.getDefaultEncoding((MuleContext)this.mockMuleContext)));
    }

    @Test
    public void testAddVariableWithEncoding() throws MuleException {
        this.addVariableProcessor.setIdentifier(PLAIN_STRING_KEY);
        this.addVariableProcessor.setValue(PLAIN_STRING_VALUE);
        this.addVariableProcessor.initialise();
        this.addVariableProcessor.setReturnDataType(DataType.builder().charset(CUSTOM_ENCODING).build());
        this.event = this.addVariableProcessor.process(this.event);
        this.verifyAdded(this.event, PLAIN_STRING_KEY, PLAIN_STRING_VALUE);
        Assert.assertThat((Object)this.getVariableDataType(this.event, PLAIN_STRING_KEY), DataTypeMatcher.like(String.class, MediaType.ANY, CUSTOM_ENCODING));
    }

    @Test
    public void testAddVariableWithMimeType() throws MimeTypeParseException, MuleException {
        this.addVariableProcessor.setIdentifier(PLAIN_STRING_KEY);
        this.addVariableProcessor.setValue(PLAIN_STRING_VALUE);
        this.addVariableProcessor.initialise();
        this.addVariableProcessor.setReturnDataType(DataType.builder().mediaType(MediaType.APPLICATION_XML).build());
        this.event = this.addVariableProcessor.process(this.event);
        this.verifyAdded(this.event, PLAIN_STRING_KEY, PLAIN_STRING_VALUE);
        Assert.assertThat((Object)this.getVariableDataType(this.event, PLAIN_STRING_KEY), DataTypeMatcher.like(String.class, MediaType.APPLICATION_XML, SystemUtils.getDefaultEncoding((MuleContext)this.mockMuleContext)));
    }

    protected abstract DataType getVariableDataType(CoreEvent var1, String var2);

    @Test(expected=IllegalArgumentException.class)
    public void testAddVariableWithNullKey() throws InitialisationException, TransformerException {
        this.addVariableProcessor.setIdentifier(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddVariableWithEmptyKey() throws InitialisationException, TransformerException {
        this.addVariableProcessor.setIdentifier("");
    }

    @Test(expected=NullPointerException.class)
    public void testAddVariableWithNullValue() throws InitialisationException, TransformerException {
        this.addVariableProcessor.setValue(null);
    }

    @Test
    public void testAddVariableWithNullExpressionKeyResult() throws MuleException {
        TypedValue typedValue = new TypedValue(null, DataType.OBJECT);
        Mockito.when((Object)this.mockSession.evaluate((String)ArgumentMatchers.eq((Object)NULL_EXPRESSION), (DataType)ArgumentMatchers.eq((Object)DataType.STRING))).thenReturn((Object)typedValue);
        this.addVariableProcessor.setIdentifier(NULL_EXPRESSION);
        this.addVariableProcessor.setValue(PLAIN_STRING_VALUE);
        this.addVariableProcessor.initialise();
        this.event = this.addVariableProcessor.process(this.event);
        this.verifyNotAdded(this.event);
    }

    @Test
    public void testAddVariableWithNullExpressionValueResult() throws MuleException {
        this.addVariableProcessor.setIdentifier(PLAIN_STRING_KEY);
        TypedValue typedValue = new TypedValue(null, DataType.OBJECT);
        Mockito.when((Object)this.mockSession.evaluate(NULL_EXPRESSION)).thenReturn((Object)typedValue);
        this.addVariableProcessor.setValue(NULL_EXPRESSION);
        this.addVariableProcessor.initialise();
        this.event = this.addVariableProcessor.process(this.event);
        this.verifyRemoved(this.event, PLAIN_STRING_KEY);
    }

    @Test
    public void testAddVariableWithNullPayloadExpressionValueResult() throws MuleException {
        this.addVariableProcessor.setIdentifier(PLAIN_STRING_KEY);
        this.addVariableProcessor.setValue(EXPRESSION);
        TypedValue typedValue = new TypedValue(null, DataType.OBJECT);
        Mockito.when((Object)this.mockSession.evaluate(EXPRESSION)).thenReturn((Object)typedValue);
        this.addVariableProcessor.initialise();
        this.event = this.addVariableProcessor.process(this.event);
        this.verifyRemoved(this.event, PLAIN_STRING_KEY);
    }

    @Test
    public void testCursorProvidersAreManaged() throws MuleException {
        CursorProvider cursorProvider = (CursorProvider)Mockito.mock(CursorProvider.class);
        this.typedValue = new TypedValue((Object)cursorProvider, DataType.CURSOR_STREAM_PROVIDER);
        Mockito.when((Object)this.mockSession.evaluate((String)ArgumentMatchers.eq((Object)EXPRESSION), (DataType)ArgumentMatchers.eq((Object)DataType.STRING))).thenReturn((Object)this.typedValue);
        Mockito.when((Object)this.mockSession.evaluate((String)ArgumentMatchers.eq((Object)EXPRESSION))).thenReturn((Object)this.typedValue);
        this.addVariableProcessor.setIdentifier(PLAIN_STRING_KEY);
        this.addVariableProcessor.setValue(EXPRESSION);
        this.addVariableProcessor.initialise();
        this.event = this.addVariableProcessor.process(this.event);
        Assert.assertThat((Object)((TypedValue)this.event.getVariables().get(PLAIN_STRING_KEY)).getValue(), (Matcher)CoreMatchers.is((Object)cursorProvider));
        ((StreamingManager)Mockito.verify((Object)this.streamingManager)).manage((CursorProvider)ArgumentMatchers.same((Object)cursorProvider), (EventContext)ArgumentMatchers.any(EventContext.class));
        this.afterAssertions = null;
    }

    protected abstract void verifyAdded(CoreEvent var1, String var2, String var3);

    protected abstract void verifyNotAdded(CoreEvent var1);

    protected abstract void verifyRemoved(CoreEvent var1, String var2);
}

