/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.el.DefaultExpressionLanguageFactoryService;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.el.ExpressionLanguageConfiguration;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerView;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.builders.AbstractConfigurationBuilder;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.registry.MuleRegistry;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.runtime.http.api.HttpService;
import org.mule.tck.SimpleUnitTestSupportSchedulerService;
import org.mule.weave.v2.el.WeaveDefaultExpressionLanguageFactoryService;

public class TestServicesConfigurationBuilder
extends AbstractConfigurationBuilder
implements TestRule {
    private static final String MOCK_HTTP_SERVICE = "mockHttpService";
    private static final String MOCK_EXPR_EXECUTOR = "mockExpressionExecutor";
    private static DefaultExpressionLanguageFactoryService cachedExprLanguageFactory;
    private static int cachedExprLanguageFactoryCounter;
    private final SimpleUnitTestSupportSchedulerService schedulerService = new SimpleUnitTestSupportSchedulerService();
    private final boolean mockHttpService;
    private final boolean mockExpressionExecutor;
    private final Map<String, Object> additionalMockedServices = new HashMap<String, Object>();
    private final Map<String, Object> overriddenDefaultServices = new HashMap<String, Object>();

    public TestServicesConfigurationBuilder() {
        this(true, true);
    }

    public TestServicesConfigurationBuilder(boolean mockHttpService, boolean mockExpressionExecutor) {
        this.mockHttpService = mockHttpService;
        this.mockExpressionExecutor = mockExpressionExecutor;
    }

    public void doConfigure(MuleContext muleContext) throws Exception {
        ClassUtils.withContextClassLoader((ClassLoader)TestServicesConfigurationBuilder.class.getClassLoader(), () -> {
            try {
                MuleRegistry registry = ((MuleContextWithRegistry)muleContext).getRegistry();
                registry.registerObject(this.schedulerService.getName(), Mockito.spy((Object)this.schedulerService));
                registry.registerObject("_muleSchedulerBaseConfig", (Object)SchedulerConfig.config());
                if (this.mockExpressionExecutor) {
                    DefaultExpressionLanguageFactoryService expressionExecutor = (DefaultExpressionLanguageFactoryService)Mockito.mock(DefaultExpressionLanguageFactoryService.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
                    registry.registerObject(MOCK_EXPR_EXECUTOR, (Object)expressionExecutor);
                } else {
                    if (cachedExprLanguageFactory == null || cachedExprLanguageFactoryCounter > 20) {
                        cachedExprLanguageFactoryCounter = 0;
                        WeaveDefaultExpressionLanguageFactoryService exprExecutor = new WeaveDefaultExpressionLanguageFactoryService(null);
                        final ExpressionLanguage exprLanguage = exprExecutor.create();
                        exprLanguage.evaluate("{dataWeave: 'is'} ++ {mule: 'default EL'}", BindingContextUtils.NULL_BINDING_CONTEXT);
                        cachedExprLanguageFactory = new DefaultExpressionLanguageFactoryService((DefaultExpressionLanguageFactoryService)exprExecutor){
                            final /* synthetic */ DefaultExpressionLanguageFactoryService val$exprExecutor;
                            {
                                this.val$exprExecutor = defaultExpressionLanguageFactoryService;
                            }

                            public ExpressionLanguage create() {
                                return exprLanguage;
                            }

                            public ExpressionLanguage create(ExpressionLanguageConfiguration configuration) {
                                return exprLanguage;
                            }

                            public String getName() {
                                return this.val$exprExecutor.getName();
                            }
                        };
                    } else {
                        ++cachedExprLanguageFactoryCounter;
                    }
                    registry.registerObject(cachedExprLanguageFactory.getName(), (Object)cachedExprLanguageFactory);
                }
                if (this.mockHttpService) {
                    registry.registerObject(MOCK_HTTP_SERVICE, Mockito.mock(HttpService.class));
                }
                this.overriddenDefaultServices.forEach((serviceId, serviceImpl) -> ((MuleContextWithRegistry)muleContext).getCustomizationService().overrideDefaultServiceImpl(serviceId, serviceImpl));
                registry.registerObjects(this.additionalMockedServices);
            }
            catch (RegistrationException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        });
    }

    public void stopServices() throws MuleException {
        List<SchedulerView> schedulers = this.schedulerService.getSchedulers();
        try {
            Assert.assertThat(schedulers, (Matcher)IsEmptyCollection.empty());
        }
        finally {
            this.schedulerService.stop();
        }
    }

    public void registerAdditionalService(String name, Object service) {
        this.additionalMockedServices.put(name, service);
    }

    public void registerOverriddenService(String name, Object service) {
        this.overriddenDefaultServices.put(name, service);
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    base.evaluate();
                }
                finally {
                    TestServicesConfigurationBuilder.this.stopServices();
                }
            }
        };
    }

    static {
        cachedExprLanguageFactoryCounter = 0;
    }
}

