/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.privileged.exception.MessagingException;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

@RunWith(value=Parameterized.class)
public abstract class AbstractReactiveProcessorTestCase
extends AbstractMuleContextTestCase {
    protected Scheduler scheduler;
    protected Mode mode;
    protected ConfigurationComponentLocator configurationComponentLocator = (ConfigurationComponentLocator)Mockito.mock(ConfigurationComponentLocator.class, (Answer)Answers.RETURNS_DEEP_STUBS);

    public AbstractReactiveProcessorTestCase(Mode mode) {
        this.mode = mode;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Mode> modeParameters() {
        return Arrays.asList(Mode.BLOCKING, Mode.NON_BLOCKING);
    }

    @Override
    protected Map<String, Object> getStartUpRegistryObjects() {
        Mockito.when((Object)this.configurationComponentLocator.find((Location)ArgumentMatchers.any(Location.class))).thenReturn(Optional.empty());
        Mockito.when((Object)this.configurationComponentLocator.find((ComponentIdentifier)ArgumentMatchers.any(ComponentIdentifier.class))).thenReturn(Collections.emptyList());
        return Collections.singletonMap("_muleConfigurationComponentLocator", this.configurationComponentLocator);
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.scheduler = muleContext.getSchedulerService().cpuIntensiveScheduler();
    }

    @Override
    protected void doTearDown() throws Exception {
        this.scheduler.stop();
        super.doTearDown();
    }

    @Override
    protected CoreEvent process(Processor processor, CoreEvent event) throws Exception {
        return this.process(processor, event, true);
    }

    protected CoreEvent process(Processor processor, CoreEvent event, boolean unwrapMessagingException) throws Exception {
        LifecycleUtils.setMuleContextIfNeeded((Object)processor, (MuleContext)muleContext);
        try {
            switch (this.mode) {
                case BLOCKING: {
                    return processor.process(event);
                }
                case NON_BLOCKING: {
                    return MessageProcessors.processToApply((CoreEvent)event, (ReactiveProcessor)processor);
                }
            }
            return null;
        }
        catch (Exception exception) {
            if (unwrapMessagingException && !(processor instanceof Flow) && exception instanceof MessagingException) {
                throw this.messagingExceptionToException((MessagingException)exception);
            }
            throw exception;
        }
    }

    private Exception messagingExceptionToException(MessagingException msgException) {
        return msgException.getCause() instanceof Exception ? (Exception)msgException.getCause() : new RuntimeException(msgException.getCause());
    }

    public static enum Mode {
        BLOCKING,
        NON_BLOCKING;

    }
}

