/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestProxyServer {
    private static final String PROXY_RESPONSE = "HTTP/1.1 200 Connection established\r\n\r\n";
    private static final Logger logger = LoggerFactory.getLogger(TestProxyServer.class);
    private int listenPort;
    private int targetPort;
    private boolean https;
    private String targetHost;
    private ServerSocket serverSocket;
    private Thread serverThread;
    ArrayList<Thread> connectionHandlers;

    public TestProxyServer(int listenPort, int targetPort, boolean https) {
        this.listenPort = listenPort;
        this.targetPort = targetPort;
        this.https = https;
        this.targetHost = "localhost";
        this.connectionHandlers = new ArrayList();
    }

    public void start() throws Exception {
        this.serverSocket = new ServerSocket(this.listenPort);
        this.serverThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        final Socket clientSocket = TestProxyServer.this.serverSocket.accept();
                        Thread handlerThread = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    TestProxyServer.this.handleRequest(clientSocket);
                                }
                                catch (Exception e) {
                                    logger.warn("handling request: {}", (Object)e.getMessage());
                                }
                            }
                        });
                        TestProxyServer.this.connectionHandlers.add(handlerThread);
                        handlerThread.start();
                    }
                }
                catch (SocketException clientSocket) {
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.serverThread.start();
    }

    public void stop() throws Exception {
        this.serverSocket.close();
        this.serverThread.join();
        for (Thread c : this.connectionHandlers) {
            c.interrupt();
            c.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest(final Socket clientSocket) throws Exception {
        if (this.https) {
            String header;
            BufferedReader reader = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()), 1);
            while ((header = reader.readLine().trim()).isEmpty()) {
            }
            if (!header.toLowerCase().startsWith("connect ")) {
                throw new RuntimeException(String.format("Test HTTP proxy received wrong header: %s", header));
            }
            reader.readLine();
            OutputStream os = clientSocket.getOutputStream();
            os.write(PROXY_RESPONSE.getBytes());
            os.flush();
        }
        final Socket targetSocket = new Socket(this.targetHost, this.targetPort);
        Thread requestThread = new Thread(){

            @Override
            public void run() {
                try {
                    IOUtils.copy((InputStream)clientSocket.getInputStream(), (OutputStream)targetSocket.getOutputStream());
                }
                catch (IOException e) {
                    logger.warn("requestThread: {}", (Object)e.getMessage());
                }
            }
        };
        Thread responseThread = new Thread(() -> {
            try {
                IOUtils.copy((InputStream)targetSocket.getInputStream(), (OutputStream)clientSocket.getOutputStream());
            }
            catch (IOException e) {
                logger.warn("responseThread: {}", (Object)e.getMessage());
            }
        });
        try {
            requestThread.start();
            responseThread.start();
            requestThread.join();
            responseThread.join();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            targetSocket.close();
            clientSocket.close();
        }
    }

    public boolean hasConnections() {
        return !this.connectionHandlers.isEmpty();
    }
}

