/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.util;

import java.util.Collection;
import java.util.Enumeration;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class EnumerationMatcher<T>
extends TypeSafeMatcher<Enumeration<T>> {
    private final Collection<T> items;

    public EnumerationMatcher(Collection<T> items) {
        this.items = items;
    }

    public boolean matchesSafely(Enumeration<T> item) {
        int enumerationSize = 0;
        while (item.hasMoreElements()) {
            T currentItem = item.nextElement();
            ++enumerationSize;
            if (this.items.contains(currentItem)) continue;
            return false;
        }
        return this.items.size() == enumerationSize;
    }

    public void describeTo(Description description) {
        description.appendText("an Enumeration containing " + this.items.toString());
    }

    public static <T> Matcher<Enumeration<T>> equalTo(Collection<T> items) {
        return new EnumerationMatcher<T>(items);
    }
}

