/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.classlaoder;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.util.Pair;

public class TestClassLoader
extends ClassLoader {
    private final Map<String, Class> classes = new HashMap<String, Class>();
    private final Map<String, URL> resources = new HashMap<String, URL>();
    private final Map<String, InputStream> streamResources = new HashMap<String, InputStream>();
    private final Map<String, String> libraries = new HashMap<String, String>();
    private final List<Pair<String, String>> invocations = new ArrayList<Pair<String, String>>();

    public TestClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        this.invocations.add((Pair<String, String>)new Pair((Object)"loadClass", (Object)name));
        return this.findClass(name);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        this.invocations.add((Pair<String, String>)new Pair((Object)"findClass", (Object)name));
        Class aClass = this.classes.get(name);
        if (aClass == null) {
            throw new TestClassNotFoundException(name, this);
        }
        return aClass;
    }

    @Override
    public URL getResource(String s) {
        this.invocations.add((Pair<String, String>)new Pair((Object)"getResource", (Object)s));
        URL url = this.resources.get(s);
        if (url == null && this.getParent() != null) {
            url = this.getParent().getResource(s);
        }
        return url;
    }

    @Override
    public InputStream getResourceAsStream(String s) {
        this.invocations.add((Pair<String, String>)new Pair((Object)"getResourceAsStream", (Object)s));
        return this.streamResources.get(s);
    }

    @Override
    public Enumeration<URL> getResources(String s) throws IOException {
        this.invocations.add((Pair<String, String>)new Pair((Object)"getResources", (Object)s));
        return this.findResources(s);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        this.invocations.add((Pair<String, String>)new Pair((Object)"findResources", (Object)name));
        return Collections.enumeration(this.resources.values());
    }

    @Override
    protected URL findResource(String s) {
        this.invocations.add((Pair<String, String>)new Pair((Object)"findResource", (Object)s));
        return this.resources.get(s);
    }

    @Override
    protected String findLibrary(String s) {
        this.invocations.add((Pair<String, String>)new Pair((Object)"findLibrary", (Object)s));
        return this.libraries.get(s);
    }

    public void addClass(String className, Class aClass) {
        this.classes.put(className, aClass);
    }

    public void addResource(String resourceName, URL resourceUrl) {
        this.resources.put(resourceName, resourceUrl);
    }

    public void addStreamResource(String resourceName, InputStream resourceStream) {
        this.streamResources.put(resourceName, resourceStream);
    }

    public void addLibrary(String libraryName, String libraryPath) {
        this.libraries.put(libraryName, libraryPath);
    }

    @Override
    protected synchronized Class<?> loadClass(String s, boolean b) throws ClassNotFoundException {
        this.invocations.add((Pair<String, String>)new Pair((Object)"loadClass", (Object)s));
        return this.loadClass(s);
    }

    public List<Pair<String, String>> getInvocations() {
        return this.invocations;
    }

    public static class TestClassNotFoundException
    extends ClassNotFoundException {
        private static final long serialVersionUID = 1L;
        private final ClassLoader classLoader;

        public TestClassNotFoundException(String s, ClassLoader classLoader) {
            super(s);
            this.classLoader = classLoader;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }
    }
}

