/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.util;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class CollectableReference<T>
extends PhantomReference<T> {
    private T strongReference;
    private final String strongReferenceAsString;

    public CollectableReference(T referent) {
        super(referent, new ReferenceQueue());
        this.strongReference = referent;
        this.strongReferenceAsString = referent.toString();
    }

    @Override
    public T get() {
        return this.strongReference;
    }

    private void dereference() {
        this.strongReference = null;
    }

    public static Matcher<CollectableReference> collectedByGc() {
        return new CollectedByGC();
    }

    public String toString() {
        return this.strongReferenceAsString;
    }

    private static class CollectedByGC
    extends TypeSafeMatcher<CollectableReference> {
        private String referencedAsString;

        private CollectedByGC() {
        }

        protected boolean matchesSafely(CollectableReference reference) {
            if (reference.get() != null) {
                this.referencedAsString = reference.get().toString();
            }
            reference.dereference();
            System.gc();
            return reference.isEnqueued();
        }

        public void describeTo(Description description) {
            description.appendText(String.format("no strong reference to '%s' is being maintained", this.referencedAsString));
        }
    }
}

