/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4.matcher;

import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.collection.IsMapContaining;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.security.SecurityContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.tck.junit4.matcher.ErrorTypeMatcher;

public class EventMatcher
extends TypeSafeMatcher<CoreEvent> {
    private Matcher<Message> messageMatcher;
    private Matcher<Map<? extends String, ? extends TypedValue<Object>>> variablesMatcher;
    private Matcher<ErrorType> errorTypeMatcher;
    private Matcher<SecurityContext> securityContextMatcher;

    public EventMatcher(Matcher<Message> messageMatcher, Matcher<Map<? extends String, ? extends TypedValue<Object>>> variablesMatcher, Matcher<ErrorType> errorTypeMatcher, Matcher<SecurityContext> securityContextMatcher) {
        this.messageMatcher = messageMatcher;
        this.variablesMatcher = variablesMatcher;
        this.errorTypeMatcher = errorTypeMatcher;
        this.securityContextMatcher = securityContextMatcher;
    }

    public static EventMatcher hasErrorTypeThat(Matcher<ErrorType> errorTypeMatcher) {
        return new EventMatcher(null, null, errorTypeMatcher, null);
    }

    public static EventMatcher hasErrorType(ErrorTypeDefinition type) {
        return new EventMatcher(null, null, (Matcher<ErrorType>)ErrorTypeMatcher.errorType(type), null);
    }

    public static EventMatcher hasErrorType(String namespace, String type) {
        return new EventMatcher(null, null, (Matcher<ErrorType>)ErrorTypeMatcher.errorType(namespace, type), null);
    }

    public static EventMatcher hasErrorType(Matcher<String> namespace, Matcher<String> type) {
        return new EventMatcher(null, null, (Matcher<ErrorType>)ErrorTypeMatcher.errorType(namespace, type), null);
    }

    public static EventMatcher hasMessage(Matcher<Message> messageMatcher) {
        return new EventMatcher(messageMatcher, null, null, null);
    }

    public static EventMatcher hasVariables(Matcher<Map<? extends String, ? extends TypedValue<Object>>> variablesMatcher) {
        return new EventMatcher(null, variablesMatcher, null, null);
    }

    public static EventMatcher hasVariable(Matcher<? super String> nameMatcher, Matcher<? super TypedValue<Object>> valueMatcher) {
        return new EventMatcher(null, (Matcher<Map<? extends String, ? extends TypedValue<Object>>>)IsMapContaining.hasEntry(nameMatcher, valueMatcher), null, null);
    }

    public static EventMatcher hasSecurityContext(Matcher<SecurityContext> securityContextMatcher) {
        return new EventMatcher(null, null, null, securityContextMatcher);
    }

    protected boolean matchesSafely(CoreEvent item) {
        return !(this.messageMatcher != null && !this.messageMatcher.matches((Object)item.getMessage()) || this.variablesMatcher != null && !this.variablesMatcher.matches((Object)item.getVariables()) || this.securityContextMatcher != null && !this.securityContextMatcher.matches((Object)item.getSecurityContext()) || this.errorTypeMatcher != null && !this.errorTypeMatcher.matches((Object)((Error)item.getError().get()).getErrorType()));
    }

    public void describeTo(Description description) {
        description.appendText("an Event with ");
        if (this.messageMatcher != null) {
            this.messageMatcher.describeTo(description);
        }
        if (this.variablesMatcher != null) {
            this.variablesMatcher.describeTo(description);
        }
        if (this.errorTypeMatcher != null) {
            this.errorTypeMatcher.describeTo(description);
        }
        if (this.securityContextMatcher != null) {
            this.securityContextMatcher.describeTo(description);
        }
    }

    protected void describeMismatchSafely(CoreEvent item, Description mismatchDescription) {
        mismatchDescription.appendText("was ");
        if (this.messageMatcher != null) {
            this.messageMatcher.describeMismatch((Object)item.getMessage(), mismatchDescription);
        }
        if (this.variablesMatcher != null) {
            this.variablesMatcher.describeMismatch((Object)item.getVariables(), mismatchDescription);
        }
        if (this.errorTypeMatcher != null) {
            this.errorTypeMatcher.describeMismatch((Object)((Error)item.getError().get()).getErrorType(), mismatchDescription);
        }
        if (this.securityContextMatcher != null) {
            this.securityContextMatcher.describeMismatch((Object)item.getSecurityContext(), mismatchDescription);
        }
    }
}

