/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.report;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;

public class HeapDumper {
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static volatile HotSpotDiagnosticMXBean hotspotMBean;

    static void dumpHeap(String fileName, boolean live) {
        HeapDumper.initHotspotMBean();
        try {
            hotspotMBean.dumpHeap(fileName, live);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initHotspotMBean() {
        if (hotspotMBean != null) return;
        Class<HeapDumper> clazz = HeapDumper.class;
        synchronized (HeapDumper.class) {
            if (hotspotMBean != null) return;
            hotspotMBean = HeapDumper.getHotspotMBean();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static HotSpotDiagnosticMXBean getHotspotMBean() {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            HotSpotDiagnosticMXBean bean = ManagementFactory.newPlatformMXBeanProxy(server, HOTSPOT_BEAN_NAME, HotSpotDiagnosticMXBean.class);
            return bean;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    public static void main(String[] args) {
        String fileName = "heap_" + System.currentTimeMillis() + ".hprof";
        boolean live = true;
        switch (args.length) {
            case 2: {
                live = args[1].equals("true");
            }
            case 1: {
                fileName = args[0];
            }
        }
        HeapDumper.dumpHeap(fileName, live);
    }
}

