/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.mockito.Mock;
import org.mule.runtime.api.util.Pair;

public class MockInjector {
    private MockInjector() {
    }

    public static void injectMocksFromSuite(Object test, Object target) {
        List<Object> candidates = MockInjector.getClassesInHierarchy(test).stream().flatMap(c -> Arrays.stream(c.getDeclaredFields())).filter(f -> f.getAnnotation(Mock.class) != null).map(f -> {
            try {
                f.setAccessible(true);
                return f.get(test);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
        }).toList();
        MockInjector.getClassesInHierarchy(target).stream().flatMap(c -> Arrays.stream(c.getDeclaredFields())).filter(f -> f.getAnnotation(Inject.class) != null).peek(f -> f.setAccessible(true)).map(f -> new Pair(f, candidates.stream().filter(o -> f.getType().isAssignableFrom(o.getClass())).findFirst())).filter(p -> ((Optional)p.getSecond()).isPresent()).forEach(p -> {
            try {
                ((Field)p.getFirst()).set(target, ((Optional)p.getSecond()).get());
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
        });
    }

    public static List<Class<?>> getClassesInHierarchy(Object base) {
        ArrayList classes = new ArrayList();
        Class<?> c = base.getClass();
        while (!c.equals(Object.class)) {
            classes.add(c);
            c = c.getSuperclass();
        }
        return classes;
    }
}

