/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.serialization.JavaObjectSerializer;
import org.mule.runtime.core.privileged.registry.RegistrationException;

public abstract class SerializationTestUtils {
    private static final String key = "SerializationTestComponentKey";

    public static <T extends Exception> T testException(T exception, MuleContext muleContext) {
        ObjectStore<T> os;
        try {
            os = SerializationTestUtils.getObjectStore(muleContext);
        }
        catch (RegistrationException e) {
            throw new RuntimeException(e);
        }
        try {
            os.store(key, exception);
            Exception e = (Exception)os.retrieve(key);
            return (T)e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                os.clear();
            }
            catch (ObjectStoreException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static <T extends Exception> ObjectStore<T> getObjectStore(MuleContext muleContext) throws RegistrationException {
        return ((ObjectStoreManager)((MuleContextWithRegistry)muleContext).getRegistry().lookupObject(ObjectStoreManager.class)).createObjectStore("SerializationTestUtils", ObjectStoreSettings.builder().persistent(true).build());
    }

    public static ObjectSerializer getJavaSerializerWithMockContext() {
        MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)muleContext.getExecutionClassLoader()).thenReturn((Object)ObjectSerializer.class.getClassLoader());
        return SerializationTestUtils.getJavaSerializer(muleContext);
    }

    public static ObjectSerializer addJavaSerializerToMockMuleContext(MuleContext mockMuleContext) {
        ObjectSerializer objectSerializer = SerializationTestUtils.getJavaSerializer(mockMuleContext);
        Mockito.when((Object)mockMuleContext.getObjectSerializer()).thenReturn((Object)objectSerializer);
        return objectSerializer;
    }

    private static ObjectSerializer getJavaSerializer(MuleContext muleContext) {
        JavaObjectSerializer serializer = new JavaObjectSerializer();
        serializer.setMuleContext(muleContext);
        return serializer;
    }
}

