/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.core.util.queue;

import java.io.Serializable;
import org.junit.Assert;
import org.mule.runtime.core.api.util.queue.Queue;
import org.mule.runtime.core.api.util.queue.QueueManager;
import org.mule.runtime.core.api.util.queue.QueueSession;

public class QueueTestComponent {
    public void testDisposal(QueueManager mgr, boolean transactional) throws Exception {
        String queueName = "myQueue";
        mgr.start();
        QueueSession session = mgr.getQueueSession();
        if (transactional) {
            session.begin();
        }
        Queue queue = mgr.getQueueSession().getQueue("myQueue");
        this.assertQueueDisposal(mgr, queue, (QueueSession)(transactional ? session : null), "myQueue");
    }

    private void assertQueueDisposal(QueueManager mgr, Queue queue, QueueSession session, String queueName) throws Exception {
        queue.put((Serializable)((Object)"some value"));
        Assert.assertEquals((long)1L, (long)queue.size());
        if (session != null) {
            session.commit();
        }
        queue.dispose();
        Queue queue2 = mgr.getQueueSession().getQueue(queueName);
        junit.framework.Assert.assertNotSame((Object)queue, (Object)queue2);
        Assert.assertEquals((long)0L, (long)queue2.size());
    }
}

