/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.core.internal.serialization;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNull;
import org.junit.Test;
import org.mule.runtime.api.serialization.SerializationProtocol;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public abstract class AbstractSerializerProtocolContractTestCase
extends AbstractMuleContextTestCase {
    private static final String STRING_MESSAGE = "Hello World";
    protected SerializationProtocol serializationProtocol;

    @Test(expected=NullPointerException.class)
    public final void nullBytes() throws Exception {
        this.serializationProtocol.deserialize((byte[])null);
    }

    @Test(expected=NullPointerException.class)
    public final void nullStream() throws Exception {
        this.serializationProtocol.deserialize((InputStream)null);
    }

    @Test
    public final void nullObject() throws Exception {
        byte[] bytes = this.serializationProtocol.serialize(null);
        Object object = this.serializationProtocol.deserialize(bytes);
        MatcherAssert.assertThat((Object)object, (Matcher)IsNull.nullValue());
    }

    @Test
    public final void inputStreamClosed() throws Exception {
        byte[] bytes = this.serializationProtocol.serialize((Object)STRING_MESSAGE);
        CloseCounterInputStreamWrapper inputStream = new CloseCounterInputStreamWrapper(new ByteArrayInputStream(bytes));
        String output = (String)this.serializationProtocol.deserialize((InputStream)inputStream);
        MatcherAssert.assertThat((Object)inputStream.getCloseCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        MatcherAssert.assertThat((Object)output, (Matcher)CoreMatchers.equalTo((Object)STRING_MESSAGE));
    }

    public class CloseCounterInputStreamWrapper
    extends InputStream {
        private final InputStream inputStream;
        private final AtomicInteger closeCount = new AtomicInteger();

        public CloseCounterInputStreamWrapper(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public int read() throws IOException {
            return this.inputStream.read();
        }

        @Override
        public void close() throws IOException {
            this.closeCount.incrementAndGet();
            this.inputStream.close();
        }

        public int getCloseCount() {
            return this.closeCount.intValue();
        }
    }
}

