/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.mule.maven.pom.parser.api.MavenPomParser;
import org.mule.maven.pom.parser.api.MavenPomParserProvider;
import org.mule.maven.pom.parser.api.model.MavenPomModel;
import org.mule.tck.ZipUtils;

public class MavenTestUtils {
    private static final String POM = "pom";

    public static Collection<File> installArtifact(File artifactFile, File repositoryLocation) throws IOException {
        String artifactExtension = FilenameUtils.getExtension((String)artifactFile.getName());
        MavenPomParser parser = MavenPomParserProvider.discoverProvider().createMavenPomParserClient(artifactFile.toPath());
        if (POM.equals(artifactExtension)) {
            return MavenTestUtils.installArtifact(artifactFile, repositoryLocation, parser);
        }
        File packagedArtifact = MavenTestUtils.packageArtifact(artifactFile, parser.getModel());
        return MavenTestUtils.installArtifact(packagedArtifact, repositoryLocation, parser);
    }

    private static File packageArtifact(File explodedArtifactFile, MavenPomModel pomModel) {
        String fileNameInRepo = pomModel.getArtifactId() + "-" + pomModel.getVersion() + (String)(pomModel.getPackaging() != null && !pomModel.getPackaging().equalsIgnoreCase("jar") ? "-" + pomModel.getPackaging() : "") + ".jar";
        File compressedFile = new File(explodedArtifactFile, fileNameInRepo);
        ZipUtils.compress(compressedFile, (ZipUtils.ZipResource[])FileUtils.listFiles((File)explodedArtifactFile, null, (boolean)true).stream().map(f -> new ZipUtils.ZipResource(f.getAbsolutePath(), MavenTestUtils.getZipEntryName(explodedArtifactFile, f))).toArray(ZipUtils.ZipResource[]::new));
        return compressedFile;
    }

    private static String getZipEntryName(File baseDir, File entryFile) {
        return baseDir.toURI().relativize(entryFile.toURI()).getPath();
    }

    private static Collection<File> installArtifact(File artifactFile, File repositoryLocation, MavenPomParser parser) throws IOException {
        MavenPomModel pomModel = parser.getModel();
        ArrayList<String> artifactLocationInRepo = new ArrayList<String>(Arrays.asList(pomModel.getGroupId().split("\\.")));
        artifactLocationInRepo.add(pomModel.getArtifactId());
        artifactLocationInRepo.add(pomModel.getVersion());
        Path pathToArtifactLocationInRepo = Paths.get(repositoryLocation.getAbsolutePath(), artifactLocationInRepo.toArray(new String[0]));
        File artifactLocationInRepoFile = pathToArtifactLocationInRepo.toFile();
        artifactLocationInRepoFile.mkdirs();
        File repoArtifactFile = new File(pathToArtifactLocationInRepo.toString(), artifactFile.getName());
        org.mule.runtime.core.api.util.FileUtils.copyFile((File)artifactFile, (File)repoArtifactFile, (boolean)true);
        String pomFileName = artifactFile.getName().replaceFirst("(.*\\.[0-9]*\\.[0-9]*\\.?[0-9]?).*", "$1") + ".pom";
        File repoPomFile = new File(pathToArtifactLocationInRepo.toString(), pomFileName);
        org.mule.runtime.core.api.util.FileUtils.copyFile((File)((File)parser.getModel().getPomFile().get()), (File)repoPomFile, (boolean)true);
        return Arrays.asList(repoArtifactFile, repoPomFile);
    }
}

