/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.transactional;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.extension.api.tx.OperationTransactionalAction;
import org.mule.test.transactional.connection.TestTransactionalConnection;

public class TransactionalOperations {
    public TestTransactionalConnection getConnection(@Connection TestTransactionalConnection connection) {
        return connection;
    }

    public void verifyNoTransaction(@Connection TestTransactionalConnection connection) {
        Preconditions.checkState((!connection.isTransactionBegun() ? 1 : 0) != 0, (String)"transaction begun with no reason");
    }

    public void verifyTransactionBegun(@Connection TestTransactionalConnection connection) {
        Preconditions.checkState((boolean)connection.isTransactionBegun(), (String)"transaction not begun");
    }

    public void verifyTransactionCommited(@Connection TestTransactionalConnection connection) {
        Preconditions.checkState((boolean)connection.isTransactionCommited(), (String)"transaction not committed");
    }

    public void verifyTransactionRolledback(@Connection TestTransactionalConnection connection) {
        Preconditions.checkState((boolean)connection.isTransactionRolledback(), (String)"transaction not rolled back");
    }

    public void verifySameConnection(@Connection TestTransactionalConnection connection, @Content TestTransactionalConnection transactionalConnection) {
        Preconditions.checkArgument((transactionalConnection != null ? 1 : 0) != 0, (String)"The transactionalConnection can't be null");
        Preconditions.checkState((connection.getConnectionId() == transactionalConnection.getConnectionId() ? 1 : 0) != 0, (String)"The connection is not the same");
    }

    public OperationTransactionalAction injectTransactionalAction(@Connection TestTransactionalConnection connection, OperationTransactionalAction action) {
        return action;
    }

    public PagingProvider<TestTransactionalConnection, Integer> pagedTransactionalOperation() throws Exception {
        return new PagingProvider<TestTransactionalConnection, Integer>(){
            private static final int SIZE = 2;
            private int count = 0;

            public List<Integer> getPage(TestTransactionalConnection connection) {
                return this.count++ < 2 ? Arrays.asList(System.identityHashCode(connection)) : Collections.emptyList();
            }

            public Optional<Integer> getTotalResults(TestTransactionalConnection connection) {
                return Optional.of(2);
            }

            public void close() throws IOException {
            }

            public boolean useStickyConnections() {
                return false;
            }
        };
    }

    public void fail() {
        throw new RuntimeException("you better rollback!");
    }
}

