/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.transactionalxa.connection;

import javax.transaction.xa.XAResource;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.sdk.api.connectivity.XATransactionalConnection;
import org.mule.test.transactionalxa.connection.DummyXaResource;
import org.mule.test.transactionalxa.connection.TestTransactionalConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestXaTransactionalConnection
implements TestTransactionalConnection,
XATransactionalConnection {
    private static final Logger logger = LoggerFactory.getLogger(TestXaTransactionalConnection.class);
    private DummyXaResource xaResource;
    private long connectionId;

    TestXaTransactionalConnection(DummyXaResource xaResource) {
        this.xaResource = xaResource;
        this.connectionId = CONNECTION_ID_PROVIDER.getAndIncrement();
    }

    public void begin() throws TransactionException {
        logger.debug("Begin Conn Transaction");
    }

    public void commit() throws TransactionException {
        logger.debug("Commit Conn Transaction");
    }

    public void rollback() throws TransactionException {
        logger.debug("Rollback Conn Transaction");
    }

    public XAResource getXAResource() {
        logger.debug("Giving XA Resource");
        return this.xaResource;
    }

    public void close() {
        logger.debug("Closing XA Transaction");
    }

    @Override
    public long getConnectionId() {
        return this.connectionId;
    }

    @Override
    public boolean isTransactionBegun() {
        return this.xaResource.isTxStarted();
    }

    @Override
    public boolean isTransactionCommited() {
        return this.xaResource.isCommitStarted();
    }

    @Override
    public boolean isTransactionRolledback() {
        return this.xaResource.isRollbackExecuted();
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean isConnected() {
        return false;
    }
}

