/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.test.tpp.extensions;

import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.sdk.api.annotation.metadata.OutputResolver;
import org.mule.test.tpp.extensions.resolver.NullTypeResover;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;

import org.apache.commons.collections4.list.UnmodifiableList;
import org.apache.commons.collections4.map.UnmodifiableMap;
import org.apache.commons.collections4.set.UnmodifiableSet;

public class Uses3ppCollectionsOperations {

  @OutputResolver(output = NullTypeResover.class)
  public List guavaList(@Optional(defaultValue = "#[payload]") List value) {
    return ImmutableList.copyOf(value);
  }

  @OutputResolver(output = NullTypeResover.class)
  public Set guavaSet(@Optional(defaultValue = "#[payload]") Set value) {
    return ImmutableSet.copyOf(value);
  }

  @OutputResolver(output = NullTypeResover.class)
  public Map guavaMap(@Optional(defaultValue = "#[payload]") Map value) {
    return ImmutableMap.copyOf(value);
  }

  @OutputResolver(output = NullTypeResover.class)
  public List commonsList(@Optional(defaultValue = "#[payload]") List value) {
    return UnmodifiableList.unmodifiableList(value);
  }

  @OutputResolver(output = NullTypeResover.class)
  public Set commonsSet(@Optional(defaultValue = "#[payload]") Set value) {
    return UnmodifiableSet.unmodifiableSet(value);
  }

  @OutputResolver(output = NullTypeResover.class)
  public Map commonsMap(@Optional(defaultValue = "#[payload]") Map value) {
    return UnmodifiableMap.unmodifiableMap(value);
  }

}
