/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.api.flow;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.junit.Assert;
import org.mule.functional.api.flow.FlowConstructRunner;
import org.mule.functional.api.flow.TransactionConfigEnum;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.execution.ExecutionCallback;
import org.mule.runtime.core.api.execution.ExecutionTemplate;
import org.mule.runtime.core.api.execution.TransactionalExecutionTemplate;
import org.mule.runtime.core.api.transaction.MuleTransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionFactory;
import org.mule.tck.processor.FlowAssert;
import org.reactivestreams.Publisher;
import reactor.core.publisher.MonoProcessor;

public class FlowRunner
extends FlowConstructRunner<FlowRunner>
implements Disposable {
    private String flowName;
    private ExecutionTemplate<InternalEvent> txExecutionTemplate = callback -> (InternalEvent)callback.process();
    private Function<InternalEvent, InternalEvent> responseEventTransformer = input -> input;
    private Scheduler scheduler;
    private MonoProcessor externalCompletionCallback = MonoProcessor.create();

    public FlowRunner(MuleContext muleContext, String flowName) {
        super(muleContext);
        this.flowName = flowName;
    }

    public FlowRunner transactionally(TransactionConfigEnum action, TransactionFactory factory) {
        MuleTransactionConfig transactionConfig = new MuleTransactionConfig(action.getAction());
        transactionConfig.setFactory(factory);
        this.txExecutionTemplate = TransactionalExecutionTemplate.createTransactionalExecutionTemplate((MuleContext)this.muleContext, (TransactionConfig)transactionConfig);
        return this;
    }

    public FlowRunner keepStreamsOpen() {
        this.eventBuilder.setExternalCompletionCallback((Publisher<Void>)this.externalCompletionCallback);
        return this;
    }

    public FlowRunner withScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public InternalEvent run() throws Exception {
        return this.runAndVerify(this.flowName);
    }

    public InternalEvent runNoVerify() throws Exception {
        return this.runAndVerify(new String[0]);
    }

    public InternalEvent runAndVerify(String ... flowNamesToVerify) throws Exception {
        InternalEvent response;
        Flow flow = (Flow)this.getFlowConstruct();
        if (this.scheduler == null) {
            response = (InternalEvent)this.txExecutionTemplate.execute(this.getFlowRunCallback(flow));
        } else {
            try {
                response = (InternalEvent)this.scheduler.submit(() -> (InternalEvent)this.txExecutionTemplate.execute(this.getFlowRunCallback(flow))).get();
            }
            catch (ExecutionException executionException) {
                Throwable cause = executionException.getCause();
                throw cause instanceof Exception ? (Exception)cause : new RuntimeException(cause);
            }
        }
        this.verify(flowNamesToVerify);
        return this.responseEventTransformer.apply(response);
    }

    public void dispatch() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct();
        try {
            this.txExecutionTemplate.execute(this.getFlowDispatchCallback(flow));
        }
        catch (Exception exception) {
            // empty catch block
        }
        FlowAssert.verify((String)this.flowName);
    }

    public void dispatchAsync() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct();
        this.scheduler = this.muleContext.getSchedulerService().ioScheduler(this.muleContext.getSchedulerBaseConfig().withShutdownTimeout(0L, TimeUnit.SECONDS));
        try {
            this.scheduler.submit(() -> (InternalEvent)this.txExecutionTemplate.execute(this.getFlowDispatchCallback(flow)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        FlowAssert.verify((String)this.flowName);
    }

    private ExecutionCallback<InternalEvent> getFlowRunCallback(Flow flow) {
        return () -> flow.process(this.getOrBuildEvent());
    }

    private ExecutionCallback<InternalEvent> getFlowDispatchCallback(Flow flow) {
        return () -> {
            flow.process(this.getOrBuildEvent());
            return null;
        };
    }

    private void verify(String ... flowNamesToVerify) throws Exception {
        for (String flowNameToVerify : flowNamesToVerify) {
            FlowAssert.verify((String)flowNameToVerify);
        }
    }

    public MessagingException runExpectingException() throws Exception {
        try {
            this.runNoVerify();
            Assert.fail((String)"Flow executed successfully. Expecting exception");
            return null;
        }
        catch (MessagingException e) {
            this.verify(this.getFlowConstructName());
            return e;
        }
    }

    @Override
    public String getFlowConstructName() {
        return this.flowName;
    }

    public void dispose() {
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
        this.externalCompletionCallback.onComplete();
    }
}

