/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.api.flow;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import javax.activation.DataHandler;
import org.junit.Assert;
import org.mule.functional.api.flow.TestEventBuilder;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.message.GroupCorrelation;

public abstract class FlowConstructRunner<R extends FlowConstructRunner> {
    protected MuleContext muleContext;
    protected TestEventBuilder eventBuilder = new TestEventBuilder();
    private InternalEvent requestEvent;

    public R withPayload(Object payload) {
        this.eventBuilder.withPayload(payload);
        return (R)this;
    }

    public R withMediaType(MediaType mediaType) {
        this.eventBuilder.withMediaType(mediaType);
        return (R)this;
    }

    public R withAttributes(Object attributes) {
        this.eventBuilder.withAttributes(attributes);
        return (R)this;
    }

    @Deprecated
    public R withInboundProperty(String key, Serializable value) {
        this.eventBuilder.withInboundProperty(key, value);
        return (R)this;
    }

    @Deprecated
    public R withInboundProperties(Map<String, Serializable> properties) {
        this.eventBuilder.withInboundProperties(properties);
        return (R)this;
    }

    @Deprecated
    public R withOutboundProperty(String key, Serializable value) {
        this.eventBuilder.withOutboundProperty(key, value);
        return (R)this;
    }

    @Deprecated
    public R withInboundAttachment(String key, DataHandler value) {
        this.eventBuilder.withInboundAttachment(key, value);
        return (R)this;
    }

    @Deprecated
    public R withSessionProperty(String key, Object value) {
        this.eventBuilder.withSessionProperty(key, value);
        return (R)this;
    }

    public R withSourceCorrelationId(String sourceCorrelationId) {
        this.eventBuilder.withSourceCorrelationId(sourceCorrelationId);
        return (R)this;
    }

    public R withCorrelation(GroupCorrelation correlation) {
        this.eventBuilder.withCorrelation(correlation);
        return (R)this;
    }

    public R withVariable(String key, Object value) {
        this.eventBuilder.withVariable(key, value);
        return (R)this;
    }

    public R withVariable(String key, Object value, DataType dataType) {
        this.eventBuilder.withVariable(key, value, dataType);
        return (R)this;
    }

    public R spyObjects() {
        this.eventBuilder.spyObjects();
        return (R)this;
    }

    public FlowConstructRunner(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    protected InternalEvent getOrBuildEvent() {
        if (this.requestEvent == null) {
            this.doBuildEvent();
        }
        return this.requestEvent;
    }

    public InternalEvent buildEvent() {
        if (this.requestEvent == null) {
            this.doBuildEvent();
            return this.requestEvent;
        }
        Assert.fail((String)"An event has already been build. Maybe you forgot to call reset()?");
        return null;
    }

    private void doBuildEvent() {
        FlowConstruct flow = this.getFlowConstruct();
        this.requestEvent = this.eventBuilder.build(flow);
    }

    protected FlowConstruct getFlowConstruct() {
        FlowConstruct flow = this.muleContext.getRegistry().lookupFlowConstruct(this.getFlowConstructName());
        Objects.requireNonNull(flow, String.format("No flow with name '%s' found.", this.getFlowConstructName()));
        return flow;
    }

    public void reset() {
        this.requestEvent = null;
    }

    public abstract String getFlowConstructName();
}

