/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.api.component;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Description;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.mule.functional.api.component.AbstractLogChecker;

public class StacktraceLogChecker
extends AbstractLogChecker {
    private static final String ANY = "(any)";
    private List<MethodCall> expectedCalls = new ArrayList<MethodCall>();
    private List<ExceptionCause> expectedExceptionCauses = new ArrayList<ExceptionCause>();

    @Override
    public void check(String logMessage) {
        StringBuilder errors = new StringBuilder();
        List<String> stackTraceLines = this.getStacktraceLinesFromLogLines(this.splitLines(logMessage));
        ArrayList<MethodCall> actualStackCalls = new ArrayList<MethodCall>();
        ArrayList<ExceptionCause> actualExceptionCauses = new ArrayList<ExceptionCause>();
        for (String line : stackTraceLines) {
            this.saveLineAsMatchingPojo(line, actualStackCalls, actualExceptionCauses);
        }
        this.validateCalls(actualStackCalls, errors);
        this.validateCauses(actualExceptionCauses, errors);
        String errorMessage = errors.toString();
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            throw new AssertionError((Object)(System.lineSeparator() + errorMessage));
        }
    }

    private void validateCalls(List<MethodCall> actualCalls, StringBuilder errors) {
        for (MethodCall call : this.expectedCalls) {
            this.assertAndSaveError(actualCalls, Matchers.hasItem(MethodCall.compatibleWith(call)), "Expected method call not found in stacktrace:", errors);
        }
    }

    private void validateCauses(List<ExceptionCause> actualCauses, StringBuilder errors) {
        for (ExceptionCause cause : this.expectedExceptionCauses) {
            this.assertAndSaveError(actualCauses, Matchers.hasItem((Object)cause), "Expected exception cause not found in stacktrace:", errors);
        }
    }

    private void saveLineAsMatchingPojo(String line, List<MethodCall> actualCalls, List<ExceptionCause> actualCauses) {
        Matcher stackTraceMatcher = STACKTRACE_METHOD_CALL_REGEX_PATTERN.matcher(line);
        if (stackTraceMatcher.matches()) {
            actualCalls.add(this.createMethodCallFromMatcher(stackTraceMatcher));
        } else {
            Matcher filteredStackEntryMatcher = STACKTRACE_FILTERED_ENTRY_REGEX_PATTERN.matcher(line);
            if (filteredStackEntryMatcher.matches()) {
                actualCalls.add(this.createMethodCallFromMatcher(filteredStackEntryMatcher));
            } else {
                Matcher exceptionCauseMatcher = STACKTRACE_EXCEPTION_CAUSE_REGEX_PATTERN.matcher(line);
                if (exceptionCauseMatcher.matches()) {
                    actualCauses.add(this.createExceptionCauseFromMatcher(exceptionCauseMatcher));
                }
            }
        }
    }

    private MethodCall createMethodCallFromMatcher(Matcher matcher) {
        if (matcher.group(4).equals("")) {
            return new MethodCall(matcher.group(1), matcher.group(2), matcher.group(3));
        }
        return new MethodCall(matcher.group(1), matcher.group(2), matcher.group(3), Integer.parseInt(matcher.group(4)));
    }

    private ExceptionCause createExceptionCauseFromMatcher(Matcher matcher) {
        return new ExceptionCause(matcher.group(2));
    }

    public void setExpectedCalls(List<MethodCall> expectedCalls) {
        this.expectedCalls = expectedCalls;
    }

    public List<MethodCall> getExpectedCalls() {
        return this.expectedCalls;
    }

    public List<ExceptionCause> getExpectedExceptionCauses() {
        return this.expectedExceptionCauses;
    }

    public void setExpectedExceptionCauses(List<ExceptionCause> expectedExceptionCauses) {
        this.expectedExceptionCauses = expectedExceptionCauses;
    }

    public static class ExceptionCause {
        private String exception = "";

        public ExceptionCause(String exception) {
            this.exception = exception;
        }

        public ExceptionCause() {
        }

        public String getException() {
            return this.exception;
        }

        public void setException(String exception) {
            this.exception = exception;
        }

        public String toString() {
            return this.exception;
        }

        public int hashCode() {
            return this.exception.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ExceptionCause)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            return this.exception.equals(((ExceptionCause)obj).exception);
        }
    }

    public static class MethodCall {
        private String packageName = null;
        private String clazz = null;
        private String method = null;
        Integer lineNumber = null;

        private void setFields(String packageName, String clazz, String method) {
            this.packageName = packageName;
            this.clazz = clazz;
            this.method = method;
        }

        public static org.hamcrest.Matcher<MethodCall> compatibleWith(final MethodCall thisCall) {
            return new TypeSafeMatcher<MethodCall>(){

                protected boolean matchesSafely(MethodCall otherCall) {
                    if (thisCall.method != null && otherCall.method != null && !thisCall.method.equals(otherCall.method)) {
                        return false;
                    }
                    if (thisCall.clazz != null && otherCall.clazz != null && !thisCall.clazz.equals(otherCall.clazz)) {
                        return false;
                    }
                    if (thisCall.packageName != null && otherCall.packageName != null && !thisCall.packageName.equals(otherCall.packageName)) {
                        return false;
                    }
                    return thisCall.lineNumber == null || otherCall.lineNumber == null || thisCall.lineNumber.equals(otherCall.lineNumber);
                }

                protected void describeMismatchSafely(MethodCall otherCall, Description mismatchDescription) {
                    mismatchDescription.appendText(otherCall.toString());
                }

                public void describeTo(Description description) {
                    description.appendText(thisCall.toString());
                }
            };
        }

        public MethodCall() {
        }

        public MethodCall(String packageName, String clazz, String method) {
            this.setFields(packageName, clazz, method);
        }

        public MethodCall(String packageName, String clazz, String method, Integer lineNumber) {
            this.setFields(packageName, clazz, method);
            this.lineNumber = lineNumber;
        }

        public boolean isLineNumberSet() {
            return this.lineNumber != null;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getClazz() {
            return this.clazz;
        }

        public void setClazz(String clazz) {
            this.clazz = clazz;
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public Integer getLineNumber() {
            return this.lineNumber;
        }

        public void setLineNumber(Integer lineNumber) {
            this.lineNumber = lineNumber;
        }

        public String toString() {
            String packageNameString = this.packageName != null ? this.packageName : StacktraceLogChecker.ANY;
            String classString = this.clazz != null ? this.clazz : StacktraceLogChecker.ANY;
            String methodString = this.method != null ? this.method : StacktraceLogChecker.ANY;
            String lineString = this.lineNumber != null ? Integer.toString(this.lineNumber) : StacktraceLogChecker.ANY;
            return String.format("%s.%s.%s:%s", packageNameString, classString, methodString, lineString);
        }

        public int hashCode() {
            return Objects.hash(this.method, this.packageName, this.clazz, this.lineNumber);
        }
    }
}

