/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.api.component;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.mule.functional.api.component.LogChecker;
import org.mule.runtime.api.exception.MuleException;

public abstract class AbstractLogChecker
implements LogChecker {
    protected static final Pattern STACKTRACE_METHOD_CALL_REGEX_PATTERN = Pattern.compile("^.*at ([^A-Z]*)\\.([0-9A-Z]+[^\\.]*)\\.([^\\(]*)\\([^):]*[:]?([0-9]*).*");
    protected static final Pattern STACKTRACE_FILTERED_ENTRY_REGEX_PATTERN = Pattern.compile("^.*at ([^A-Z]*)\\.\\* \\(([0-9]+) elements filtered from stack()().*");
    protected static final Pattern STACKTRACE_EXCEPTION_CAUSE_REGEX_PATTERN = Pattern.compile("\\s*(Caused by: )?([a-zA-Z0-9\\.]+(Exception|Error)+)(: .*|\\z)");
    protected static final Pattern STACKTRACE_COLLAPSED_INFORMATION_REGEX_PATTERN = Pattern.compile(".*\\.\\.\\. [0-9]* more.*");

    @Override
    public abstract void check(String var1);

    protected List<String> getMessageLinesFromLogLines(List<String> initialLogLines) {
        int index = initialLogLines.indexOf(MuleException.EXCEPTION_MESSAGE_SECTION_DELIMITER.trim());
        if (index > -1) {
            return initialLogLines.subList(0, index);
        }
        return this.removeStacktraceLines(initialLogLines);
    }

    protected List<String> getStacktraceLinesFromLogLines(List<String> initialLogLines) {
        int index = initialLogLines.indexOf(MuleException.EXCEPTION_MESSAGE_SECTION_DELIMITER.trim());
        if (index > -1) {
            return initialLogLines.subList(index, initialLogLines.size());
        }
        return this.getStacktraceLines(initialLogLines);
    }

    private boolean isStacktrace(String line) {
        return STACKTRACE_METHOD_CALL_REGEX_PATTERN.matcher(line).matches() || STACKTRACE_FILTERED_ENTRY_REGEX_PATTERN.matcher(line).matches() || STACKTRACE_EXCEPTION_CAUSE_REGEX_PATTERN.matcher(line).matches() || STACKTRACE_COLLAPSED_INFORMATION_REGEX_PATTERN.matcher(line).matches();
    }

    private List<String> getStacktraceLines(List<String> allLines) {
        return allLines.stream().filter(line -> this.isStacktrace((String)line)).collect(Collectors.toList());
    }

    private List<String> removeStacktraceLines(List<String> allLines) {
        return allLines.stream().filter(line -> !this.isStacktrace((String)line)).collect(Collectors.toList());
    }

    protected List<String> splitLines(String wholeMessage) {
        return Arrays.asList(wholeMessage.split(System.lineSeparator()));
    }

    protected <T> boolean assertAndSaveError(T checkedValue, Matcher<T> comparison, String failureMessagePrefix, StringBuilder errorCatcher) {
        try {
            MatcherAssert.assertThat(checkedValue, comparison);
        }
        catch (AssertionError e) {
            errorCatcher.append(System.lineSeparator());
            errorCatcher.append(failureMessagePrefix);
            errorCatcher.append(((Throwable)((Object)e)).getMessage());
            errorCatcher.append(System.lineSeparator());
            return false;
        }
        return true;
    }
}

