/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.api.component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matchers;
import org.mule.functional.api.component.AbstractLogChecker;

public class SummaryLogChecker
extends AbstractLogChecker {
    private static final Pattern SUMMARY_REGEX_PATTERN = Pattern.compile("([^:]*):(.*)");
    private List<SummaryInfo> expectedInfo;
    private boolean exclusiveContent;

    @Override
    public void check(String logMessage) {
        StringBuilder errors = new StringBuilder();
        HashMap<String, String> actualInfoMap = new HashMap<String, String>();
        List<String> actualLines = this.getMessageLinesFromLogLines(this.splitLines(logMessage));
        for (String line : actualLines) {
            Matcher matcher = SUMMARY_REGEX_PATTERN.matcher(line);
            if (!matcher.matches()) continue;
            actualInfoMap.put(matcher.group(1).trim(), matcher.group(2).trim());
        }
        if (this.exclusiveContent) {
            this.checkExclusive(actualInfoMap, errors);
        } else {
            this.checkNotExclusive(actualInfoMap, errors);
        }
        String errorMessage = errors.toString();
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            throw new AssertionError((Object)(System.lineSeparator() + errorMessage));
        }
    }

    private void evaluatePresentInfo(Map<String, String> actualInfo, StringBuilder errors) {
        for (SummaryInfo expectedInfoElement : this.expectedInfo) {
            if (!this.assertAndSaveError(actualInfo, Matchers.hasKey((Object)expectedInfoElement.getKey()), "Missing summary line:", errors)) continue;
            if (expectedInfoElement.getValue() != null) {
                this.assertAndSaveError(actualInfo.get(expectedInfoElement.getKey()), Matchers.is((org.hamcrest.Matcher)Matchers.equalTo((Object)expectedInfoElement.getValue())), String.format("\"%s\" has the wrong info:", expectedInfoElement.getKey()), errors);
            }
            if (expectedInfoElement.getValueStartsWith() == null) continue;
            this.assertAndSaveError(actualInfo.get(expectedInfoElement.getKey()), Matchers.startsWith((String)expectedInfoElement.getValueStartsWith()), String.format("\"%s\" has the wrong info:", expectedInfoElement.getKey()), errors);
        }
    }

    private void checkExclusive(Map<String, String> actualInfo, StringBuilder errors) {
        this.evaluatePresentInfo(actualInfo, errors);
        if (actualInfo.size() > this.expectedInfo.size()) {
            Set expectedInfoKeySet = this.expectedInfo.stream().map(SummaryInfo::getKey).collect(Collectors.toSet());
            Set<String> extraInfo = actualInfo.keySet();
            extraInfo.removeAll(expectedInfoKeySet);
            for (String key : extraInfo) {
                errors.append(System.lineSeparator());
                errors.append(String.format("Unwanted information found. Key: \"%s\" Value: \"%s\"", key, actualInfo.get(key)));
                errors.append(System.lineSeparator());
            }
        }
    }

    private void checkNotExclusive(Map<String, String> expected, StringBuilder errors) {
        this.evaluatePresentInfo(expected, errors);
    }

    public boolean isExclusiveContent() {
        return this.exclusiveContent;
    }

    public void setExclusiveContent(boolean exclusiveContent) {
        this.exclusiveContent = exclusiveContent;
    }

    public List<SummaryInfo> getExpectedInfo() {
        return this.expectedInfo;
    }

    public void setExpectedInfo(List<SummaryInfo> expectedInfo) {
        this.expectedInfo = expectedInfo;
    }

    public static class SummaryInfo {
        private String key;
        private String value = null;
        private String valueStartsWith = null;

        public SummaryInfo() {
        }

        public SummaryInfo(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public SummaryInfo(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValueStartsWith() {
            return this.valueStartsWith;
        }

        public void setValueStartsWith(String valueStartsWith) {
            this.valueStartsWith = valueStartsWith;
        }
    }
}

