/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.api.component;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.functional.api.component.StacktraceLogChecker;
import org.mule.runtime.api.exception.MuleException;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class StacktraceLogCheckerTestCase
extends AbstractMuleTestCase {
    private StacktraceLogChecker stacktraceLogChecker = new StacktraceLogChecker();
    private static final String PACKAGE = "package";
    private static final String CLASS = "Class";
    private static final String METHOD = "method";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void onlyEvaluatesStacktracePatternMatchingLines() throws Exception {
        String log = "message" + MuleException.EXCEPTION_MESSAGE_SECTION_DELIMITER + "stacktrace";
        this.stacktraceLogChecker.check(log);
    }

    @Test
    public void stacktraceShouldBeEvalatedEvenWithNoSectionDelimiter() throws Exception {
        String log = String.format("this could be%sthe message part and\tshould not be evaluated%sat package.Class.method(whatever:0)", System.lineSeparator(), System.lineSeparator());
        StacktraceLogChecker.MethodCall methodCall = new StacktraceLogChecker.MethodCall(PACKAGE, CLASS, METHOD, Integer.valueOf(0));
        this.stacktraceLogChecker.setExpectedCalls(Arrays.asList(methodCall));
        this.stacktraceLogChecker.check(log);
    }

    @Test
    public void callNotFoundShouldRaiseError() throws Exception {
        StacktraceLogChecker.MethodCall methodCall = new StacktraceLogChecker.MethodCall(PACKAGE, CLASS, METHOD, Integer.valueOf(0));
        this.stacktraceLogChecker.setExpectedCalls(Arrays.asList(methodCall));
        this.expectedException.expect(AssertionError.class);
        this.stacktraceLogChecker.check("this stacktrace does not contain expected call");
    }

    @Test
    public void callFoundShouldSucceed() throws Exception {
        StacktraceLogChecker.MethodCall methodCall = new StacktraceLogChecker.MethodCall(PACKAGE, CLASS, METHOD, Integer.valueOf(0));
        this.stacktraceLogChecker.setExpectedCalls(Arrays.asList(methodCall));
        this.stacktraceLogChecker.check("at package.Class.method(whatever:0)");
    }

    @Test
    public void noLineNumberSpecifiedShouldMatch() throws Exception {
        StacktraceLogChecker.MethodCall methodCall = new StacktraceLogChecker.MethodCall(PACKAGE, CLASS, METHOD);
        this.stacktraceLogChecker.setExpectedCalls(Arrays.asList(methodCall));
        this.stacktraceLogChecker.check("at package.Class.method(whatever:25)");
    }

    @Test
    public void noPackageSpecifiedShouldMatch() throws Exception {
        StacktraceLogChecker.MethodCall methodCall = new StacktraceLogChecker.MethodCall();
        methodCall.setLineNumber(Integer.valueOf(25));
        methodCall.setMethod(METHOD);
        methodCall.setClazz(CLASS);
        this.stacktraceLogChecker.setExpectedCalls(Arrays.asList(methodCall));
        this.stacktraceLogChecker.check("at package.Class.method(whatever:25)");
    }

    @Test
    public void noClassSpecifiedShouldMatch() throws Exception {
        StacktraceLogChecker.MethodCall methodCall = new StacktraceLogChecker.MethodCall();
        methodCall.setLineNumber(Integer.valueOf(25));
        methodCall.setMethod(METHOD);
        methodCall.setPackageName(PACKAGE);
        this.stacktraceLogChecker.setExpectedCalls(Arrays.asList(methodCall));
        this.stacktraceLogChecker.check("at package.Class.method(whatever:25)");
    }

    @Test
    public void noMethodSpecifiedShouldMatch() throws Exception {
        StacktraceLogChecker.MethodCall methodCall = new StacktraceLogChecker.MethodCall();
        methodCall.setLineNumber(Integer.valueOf(25));
        methodCall.setClazz(CLASS);
        methodCall.setPackageName(PACKAGE);
        this.stacktraceLogChecker.setExpectedCalls(Arrays.asList(methodCall));
        this.stacktraceLogChecker.check("at package.Class.method(whatever:25)");
    }

    @Test
    public void onlyMethodSpecifiedShouldMatch() throws Exception {
        StacktraceLogChecker.MethodCall methodCall = new StacktraceLogChecker.MethodCall();
        methodCall.setMethod(METHOD);
        this.stacktraceLogChecker.setExpectedCalls(Arrays.asList(methodCall));
        this.stacktraceLogChecker.check("at package.Class.method(whatever:25)");
    }

    @Test
    public void onlyClassSpecifiedShouldMatch() throws Exception {
        StacktraceLogChecker.MethodCall methodCall = new StacktraceLogChecker.MethodCall();
        methodCall.setClazz(CLASS);
        this.stacktraceLogChecker.setExpectedCalls(Arrays.asList(methodCall));
        this.stacktraceLogChecker.check("at package.Class.method(whatever:25)");
    }

    @Test
    public void onlyPackageSpecifiedShouldMatch() throws Exception {
        StacktraceLogChecker.MethodCall methodCall = new StacktraceLogChecker.MethodCall();
        methodCall.setPackageName(PACKAGE);
        this.stacktraceLogChecker.setExpectedCalls(Arrays.asList(methodCall));
        this.stacktraceLogChecker.check("at package.Class.method(whatever:25)");
    }

    @Test
    public void onlyLineSpecifiedShouldMatch() throws Exception {
        StacktraceLogChecker.MethodCall methodCall = new StacktraceLogChecker.MethodCall();
        methodCall.setLineNumber(Integer.valueOf(25));
        this.stacktraceLogChecker.setExpectedCalls(Arrays.asList(methodCall));
        this.stacktraceLogChecker.check("at package.Class.method(whatever:25)");
    }

    @Test
    public void methodAndPackageSpecifiedShouldMatch() throws Exception {
        StacktraceLogChecker.MethodCall methodCall = new StacktraceLogChecker.MethodCall();
        methodCall.setMethod(METHOD);
        methodCall.setPackageName(PACKAGE);
        this.stacktraceLogChecker.setExpectedCalls(Arrays.asList(methodCall));
        this.stacktraceLogChecker.check("at package.Class.method(whatever:25)");
    }

    @Test
    public void methodAndClassSpecifiedShouldMatch() throws Exception {
        StacktraceLogChecker.MethodCall methodCall = new StacktraceLogChecker.MethodCall();
        methodCall.setClazz(CLASS);
        methodCall.setMethod(METHOD);
        this.stacktraceLogChecker.setExpectedCalls(Arrays.asList(methodCall));
        this.stacktraceLogChecker.check("at package.Class.method(whatever:25)");
    }

    @Test
    public void methodAndLineNumberSpecifiedShouldMatch() throws Exception {
        StacktraceLogChecker.MethodCall methodCall = new StacktraceLogChecker.MethodCall();
        methodCall.setLineNumber(Integer.valueOf(25));
        methodCall.setMethod(METHOD);
        this.stacktraceLogChecker.setExpectedCalls(Arrays.asList(methodCall));
        this.stacktraceLogChecker.check("at package.Class.method(whatever:25)");
    }

    @Test
    public void packageAndClassSpecifiedShouldMatch() throws Exception {
        StacktraceLogChecker.MethodCall methodCall = new StacktraceLogChecker.MethodCall();
        methodCall.setClazz(CLASS);
        methodCall.setPackageName(PACKAGE);
        this.stacktraceLogChecker.setExpectedCalls(Arrays.asList(methodCall));
        this.stacktraceLogChecker.check("at package.Class.method(whatever:25)");
    }

    @Test
    public void packageAndLineNumberSpecifiedShouldMatch() throws Exception {
        StacktraceLogChecker.MethodCall methodCall = new StacktraceLogChecker.MethodCall();
        methodCall.setLineNumber(Integer.valueOf(25));
        methodCall.setPackageName(PACKAGE);
        this.stacktraceLogChecker.setExpectedCalls(Arrays.asList(methodCall));
        this.stacktraceLogChecker.check("at package.Class.method(whatever:25)");
    }

    @Test
    public void classAndLineNumberSpecifiedShouldMatch() throws Exception {
        StacktraceLogChecker.MethodCall methodCall = new StacktraceLogChecker.MethodCall();
        methodCall.setLineNumber(Integer.valueOf(25));
        methodCall.setClazz(CLASS);
        this.stacktraceLogChecker.setExpectedCalls(Arrays.asList(methodCall));
        this.stacktraceLogChecker.check("at package.Class.method(whatever:25)");
    }

    @Test
    public void differentMethodRepresentsDifferentExpectedMethodCalls() throws Exception {
        StacktraceLogChecker.MethodCall methodCall = new StacktraceLogChecker.MethodCall(PACKAGE, CLASS, "otherMethod", Integer.valueOf(25));
        this.stacktraceLogChecker.setExpectedCalls(Arrays.asList(methodCall));
        this.expectedException.expect(AssertionError.class);
        this.stacktraceLogChecker.check("at package.Class.method(whatever:25)");
    }

    @Test
    public void differentClassRepresentsDifferentExpectedMethodCalls() throws Exception {
        StacktraceLogChecker.MethodCall methodCall = new StacktraceLogChecker.MethodCall(PACKAGE, "OtherClass", METHOD, Integer.valueOf(25));
        this.stacktraceLogChecker.setExpectedCalls(Arrays.asList(methodCall));
        this.expectedException.expect(AssertionError.class);
        this.stacktraceLogChecker.check("at package.Class.method(whatever:25)");
    }

    @Test
    public void differentPackageRepresentsDifferentExpectedMethodCalls() throws Exception {
        StacktraceLogChecker.MethodCall methodCall = new StacktraceLogChecker.MethodCall("other.package", CLASS, METHOD, Integer.valueOf(25));
        this.stacktraceLogChecker.setExpectedCalls(Arrays.asList(methodCall));
        this.expectedException.expect(AssertionError.class);
        this.stacktraceLogChecker.check("at package.Class.method(whatever:25)");
    }

    @Test
    public void differentLineNumbersRepresentDifferentExpectedMethodCalls() throws Exception {
        StacktraceLogChecker.MethodCall methodCall = new StacktraceLogChecker.MethodCall(PACKAGE, CLASS, METHOD, Integer.valueOf(0));
        this.stacktraceLogChecker.setExpectedCalls(Arrays.asList(methodCall));
        this.expectedException.expect(AssertionError.class);
        this.stacktraceLogChecker.check("at package.Class.method(whatever:25)");
    }

    @Test
    public void methodWithNumbersInNameIsFound() throws Exception {
        this.stacktraceLogChecker.setExpectedCalls(Arrays.asList(new StacktraceLogChecker.MethodCall(PACKAGE, CLASS, "method0", Integer.valueOf(0)), new StacktraceLogChecker.MethodCall(PACKAGE, CLASS, "0method", Integer.valueOf(1)), new StacktraceLogChecker.MethodCall(PACKAGE, CLASS, "method0method", Integer.valueOf(2))));
        this.stacktraceLogChecker.check(String.format("at package.Class.method0(whatever:0)%sat package.Class.0method(whatever:1)%sat package.Class.method0method(whatever:2)", System.lineSeparator(), System.lineSeparator()));
    }

    @Test
    public void classWithNumbersInNameIsFound() throws Exception {
        this.stacktraceLogChecker.setExpectedCalls(Arrays.asList(new StacktraceLogChecker.MethodCall(PACKAGE, "Class0", METHOD, Integer.valueOf(0)), new StacktraceLogChecker.MethodCall(PACKAGE, "0Class", METHOD, Integer.valueOf(1)), new StacktraceLogChecker.MethodCall(PACKAGE, "Class0class", METHOD, Integer.valueOf(2))));
        this.stacktraceLogChecker.check(String.format("at package.Class0.method(whatever:0)%sat package.0Class.method(whatever:1)%sat package.Class0class.method(whatever:2)", System.lineSeparator(), System.lineSeparator()));
    }

    @Test
    public void evaluatesRealStacktrace() throws Exception {
        this.stacktraceLogChecker.setExpectedCalls(Arrays.asList(new StacktraceLogChecker.MethodCall("org.mule.functional.api.component", "StacktraceLogCheckerTestCase", "evaluatesRealStacktrace")));
        StringWriter s = new StringWriter();
        PrintWriter p = new PrintWriter(s);
        new Exception().printStackTrace(p);
        this.stacktraceLogChecker.check(s.toString());
    }

    @Test
    public void causeMatchSuccess() throws Exception {
        this.stacktraceLogChecker.setExpectedExceptionCauses(Arrays.asList(new StacktraceLogChecker.ExceptionCause("org.package.Exception")));
        this.stacktraceLogChecker.check(String.format("noise, more noise, not %s      important. \t%sStill not important%s Caused by: org.package.Exception%s more irrelevant stuff", System.lineSeparator(), System.lineSeparator(), System.lineSeparator(), System.lineSeparator()));
    }
}

