/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.api.component;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.functional.api.component.SummaryLogChecker;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class SummaryLogCheckerTestCase
extends AbstractMuleTestCase {
    private SummaryLogChecker summaryLogChecker = new SummaryLogChecker();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void successIfInfoFound() throws Exception {
        this.summaryLogChecker.setExclusiveContent(false);
        SummaryLogChecker.SummaryInfo summaryInfo = new SummaryLogChecker.SummaryInfo("key", "value");
        this.summaryLogChecker.setExpectedInfo(Arrays.asList(summaryInfo));
        this.summaryLogChecker.check("key: value");
    }

    @Test
    public void failureIfNoInfoFound() throws Exception {
        SummaryLogChecker.SummaryInfo summaryInfo = new SummaryLogChecker.SummaryInfo("key", "value");
        this.summaryLogChecker.setExpectedInfo(Arrays.asList(summaryInfo));
        this.expectedException.expect(AssertionError.class);
        this.summaryLogChecker.check("other stuff");
    }

    @Test
    public void keyMatchSucceedsIfNoValueSpecified() throws Exception {
        this.summaryLogChecker.setExclusiveContent(false);
        SummaryLogChecker.SummaryInfo summaryInfo = new SummaryLogChecker.SummaryInfo("key");
        this.summaryLogChecker.setExpectedInfo(Arrays.asList(summaryInfo));
        this.summaryLogChecker.check("key: some other stuff");
    }

    @Test
    public void extraInformationSucceedsIfExclusiveContentIsFalse() throws Exception {
        this.summaryLogChecker.setExclusiveContent(false);
        SummaryLogChecker.SummaryInfo summaryInfo = new SummaryLogChecker.SummaryInfo("key", "value");
        this.summaryLogChecker.setExpectedInfo(Arrays.asList(summaryInfo));
        this.summaryLogChecker.check(String.format("key: value%skey2: value2", System.lineSeparator()));
    }

    @Test
    public void extraInformationFailsIfExclusiveContentIsTrue() throws Exception {
        this.summaryLogChecker.setExclusiveContent(true);
        SummaryLogChecker.SummaryInfo summaryInfo = new SummaryLogChecker.SummaryInfo("key", "value");
        this.summaryLogChecker.setExpectedInfo(Arrays.asList(summaryInfo));
        this.expectedException.expect(AssertionError.class);
        this.summaryLogChecker.check("key: value\nkey2: value2");
    }

    @Test
    public void successWithStacktraceNoiseAndExclusiveContentAsTrue() throws Exception {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        new Exception().printStackTrace(printWriter);
        this.summaryLogChecker.setExclusiveContent(true);
        SummaryLogChecker.SummaryInfo summaryInfo = new SummaryLogChecker.SummaryInfo("key", "value");
        this.summaryLogChecker.setExpectedInfo(Arrays.asList(summaryInfo));
        this.summaryLogChecker.check(String.format("key: value%s%s", System.lineSeparator(), stringWriter.toString()));
    }
}

