/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tests.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;

public class SlowStreamingOperations {
    @MediaType(value="*/*")
    public InputStream slowInfiniteInputStream(final long delayBetweenReads) {
        return new InputStream(){
            private boolean interrupted;

            @Override
            public int read() throws IOException {
                return this.interrupted ? -1 : 0;
            }

            @Override
            public int read(byte[] b) throws IOException {
                try {
                    Thread.sleep(delayBetweenReads);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.interrupted = true;
                }
                return super.read(b);
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                try {
                    Thread.sleep(delayBetweenReads);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.interrupted = true;
                }
                return super.read(b, off, len);
            }
        };
    }

    @MediaType(value="*/*")
    public void slowInfiniteInputStreamNonBlocking(long delayBetweenReads, CompletionCallback<InputStream, Void> callback) {
        callback.success(Result.builder().output((Object)this.slowInfiniteInputStream(delayBetweenReads)).build());
    }

    public Iterator<String> slowInfiniteIterator(final long delayBetweenReads) {
        return new Iterator<String>(){
            private boolean interrupted;

            @Override
            public boolean hasNext() {
                return !this.interrupted;
            }

            @Override
            public String next() {
                try {
                    Thread.sleep(delayBetweenReads);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.interrupted = true;
                }
                return "A";
            }
        };
    }

    public void slowInfiniteIteratorNonBlocking(long delayBetweenReads, CompletionCallback<Iterator<String>, Void> callback) {
        callback.success(Result.builder().output(this.slowInfiniteIterator(delayBetweenReads)).build());
    }
}

