/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tests.api;

import java.util.Optional;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutorFactory;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.module.extension.api.loader.java.property.CompletableComponentExecutorModelProperty;
import org.mule.tests.internal.BaseLifecycleTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleTrackerEnricher
implements DeclarationEnricher {
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        ((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration()).getOperations().forEach(operation -> {
            if (operation.getName().contains("lifecycleTracker")) {
                boolean shouldCheckPhase = operation.getName().contains("Check");
                CompletableComponentExecutorFactory executorFactory = this.getExecutorFactory((OperationDeclaration)operation, shouldCheckPhase);
                operation.addModelProperty((ModelProperty)new CompletableComponentExecutorModelProperty(executorFactory));
            }
        });
    }

    private CompletableComponentExecutorFactory getExecutorFactory(OperationDeclaration operation, boolean shouldCheckPhase) {
        Optional executorModelProperty = operation.getModelProperty(CompletableComponentExecutorModelProperty.class);
        Optional<CompletableComponentExecutorFactory> oldFactory = executorModelProperty.map(CompletableComponentExecutorModelProperty::getExecutorFactory);
        return (componentModel, map) -> {
            CompletableComponentExecutor delegateExecutor = oldFactory.map(f -> f.createExecutor(componentModel, map)).orElse(null);
            return new LifecycleTrackerComponentExecutorDecorator((CompletableComponentExecutor<ComponentModel>)delegateExecutor, shouldCheckPhase);
        };
    }

    private static class LifecycleTrackerComponentExecutorDecorator
    extends BaseLifecycleTracker
    implements CompletableComponentExecutor<ComponentModel> {
        private static final Logger LOGGER = LoggerFactory.getLogger(LifecycleTrackerComponentExecutorDecorator.class);
        private final CompletableComponentExecutor<ComponentModel> delegate;

        LifecycleTrackerComponentExecutorDecorator(CompletableComponentExecutor<ComponentModel> delegate, boolean shouldCheck) {
            super(shouldCheck);
            this.delegate = delegate;
        }

        public void execute(ExecutionContext<ComponentModel> executionContext, CompletableComponentExecutor.ExecutorCallback executorCallback) {
            this.addTrackingDataToRegistry((String)executionContext.getParameter("name"));
            this.delegate.execute(executionContext, executorCallback);
        }

        @Override
        protected void onInit(MuleContext muleContext) throws InitialisationException {
            LifecycleUtils.initialiseIfNeeded(this.delegate, (MuleContext)muleContext);
        }

        @Override
        protected void onStart() throws MuleException {
            LifecycleUtils.startIfNeeded(this.delegate);
        }

        @Override
        protected void onStop() throws MuleException {
            LifecycleUtils.stopIfNeeded(this.delegate);
        }

        @Override
        protected void onDispose() {
            LifecycleUtils.disposeIfNeeded(this.delegate, (Logger)LOGGER);
        }
    }
}

