/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tests.internal;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.tests.api.LifecycleTracker;
import org.mule.tests.api.LifecycleTrackerRegistry;

public class BaseLifecycleTracker
implements Lifecycle,
MuleContextAware,
LifecycleTracker {
    @Inject
    private LifecycleTrackerRegistry registry;
    private final boolean shouldCheck;
    private MuleContext muleContext = null;
    private final List<String> alreadyCalledPhases = new ArrayList<String>();

    public BaseLifecycleTracker(boolean shouldCheck) {
        this.shouldCheck = shouldCheck;
    }

    protected void onInit(MuleContext muleContext) throws InitialisationException {
    }

    protected void onStart() throws MuleException {
    }

    protected void onStop() throws MuleException {
    }

    protected void onDispose() {
    }

    protected void onSetMuleContext(MuleContext muleContext) {
    }

    public void addTrackingDataToRegistry(String trackerName, LifecycleTrackerRegistry registry) {
        registry.add(trackerName, this);
    }

    protected void addTrackingDataToRegistry(String trackerName) {
        this.addTrackingDataToRegistry(trackerName, this.registry);
    }

    @Override
    public List<String> getCalledPhases() {
        return this.alreadyCalledPhases;
    }

    private void trackPhase(String phase) {
        if (this.shouldCheck && this.alreadyCalledPhases.contains(phase)) {
            throw new IllegalStateException(String.format("Invalid phase transition: %s -> %s", this.alreadyCalledPhases.toString(), phase));
        }
        this.alreadyCalledPhases.add(phase);
    }

    public void initialise() throws InitialisationException {
        this.trackPhase("initialise");
        this.onInit(this.muleContext);
    }

    public void start() throws MuleException {
        this.trackPhase("start");
        this.onStart();
    }

    public void stop() throws MuleException {
        this.trackPhase("stop");
        this.onStop();
    }

    public void dispose() {
        this.trackPhase("dispose");
        this.onDispose();
    }

    public void setMuleContext(MuleContext context) {
        if (this.muleContext == null) {
            this.trackPhase("setMuleContext");
            this.onSetMuleContext(this.muleContext);
        }
        this.muleContext = context;
    }
}

