/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tests.api;

import org.mule.runtime.extension.api.annotation.dsl.xml.TypeDsl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Tracks list of values classified by a reference name
 *
 * @since 1.5.0
 */
@TypeDsl(allowInlineDefinition = false)
public class ValueInterceptorContainer {

  private Map<String, List<Object>> intercepted = new HashMap<>();

  public void intercept(String reference, Object value) {
    synchronized (intercepted) {
      intercepted.computeIfAbsent(reference, k -> new ArrayList<>()).add(value);
    }
  }

  public Map<String, Object> dump() {
    synchronized (intercepted) {
      try {
        return new HashMap<>(intercepted);
      } finally {
        intercepted.clear();
      }
    }
  }
}
