/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tests.internal;

import static org.mule.runtime.api.metadata.TypedValue.of;
import static org.mule.tests.internal.DummyNotificationAction.INTEGER_NOTIFICATION;
import static org.mule.tests.internal.DummyNotificationAction.STRING_NOTIFICATION;

import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.param.ExclusiveOptionals;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.sdk.api.annotation.notification.Fires;
import org.mule.sdk.api.annotation.notification.NotificationActionProvider;
import org.mule.sdk.api.notification.NotificationActionDefinition;
import org.mule.sdk.api.notification.NotificationEmitter;

import java.util.HashSet;
import java.util.Set;

public class NotificationFiringOperations {

    @Fires(DummyNotificationActionProvider.class)
    public void fireNotification(@ParameterGroup(name = "valueToEmit") NotificationValue valueToEmit, NotificationEmitter notificationEmitter) {
        if (valueToEmit.getInteger() != null) {
            TypedValue<Integer> number = of(valueToEmit.getInteger());
            notificationEmitter.fire(INTEGER_NOTIFICATION, number);
        } else {
            TypedValue<String> string = of(valueToEmit.getString());
            notificationEmitter.fire(STRING_NOTIFICATION, string);
        }
    }

    public static class DummyNotificationActionProvider implements NotificationActionProvider {
        @Override
        public Set<NotificationActionDefinition> getNotificationActions() {
            Set<NotificationActionDefinition> actions = new HashSet<>();
            actions.add(INTEGER_NOTIFICATION);
            actions.add(STRING_NOTIFICATION);
            return actions;
        }
    }

    @ExclusiveOptionals(isOneRequired = true)
    public static class NotificationValue {

        @Parameter
        @Optional
        private Integer integer;

        @Parameter
        @Optional
        private String string;

        public Integer getInteger() {
            return integer;
        }

        public String getString() {
            return string;
        }
    }
}
